const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const ClaseController = {
  async createClase(req, res) {
    try {
      const { Nombre, Salon, Horario, idDocente, idPeriodo, idCurso } = req.body;
      const clase = await prisma.clase.create(
        {
          data: { Nombre, Salon, Horario, idDocente, idPeriodo, idCurso }
        }
      );
      res.json(clase);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'Clase creada correctamente',
      //     data: clase
      //   }
      // );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Clase',
          error: error
        }
      );
    }
  },

  async getAllClases(req, res) {
    try {
      const clases = await prisma.clase.findMany();
      if (clases.length > 0) {
        res.json(clases);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Clases',
        //     data: clases
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Clases registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Clases',
          error
        }
      );
    }
  },

  async periodoClase(req, res) {
    try {
      const { codigo } = req.params;
      const clases = await prisma.clase.findMany(
        {
          where: {
            idPeriodo: parseInt(codigo)
          }
        }
      );
      if (clases.length > 0) {
        res.json(clases);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Clases de la Empresa indicada',
        //     data: clases
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Clases registradas de la Empresa indicada'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Clases',
          error
        }
      );
    }
  },

  async docenteperiodoClase(req, res) {
    try {
      const { docente, periodo } = req.params;
      const clases = await prisma.clase.findMany(
        {
          where: {
            idDocente: parseInt(docente),
            idPeriodo: parseInt(periodo)
          }
        }
      );
      if (clases.length > 0) {
        res.json(clases);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Clases de la Empresa indicada',
        //     data: clases
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Clases registradas de la Empresa indicada'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Clases',
          error
        }
      );
    }
  },

  async docenteperiodocursoClase(req, res) {
    try {
      const { docente, periodo, curso } = req.params;
      const clases = await prisma.clase.findMany(
        {
          where: {
            idDocente: parseInt(docente),
            idPeriodo: parseInt(periodo),
            idCurso: parseInt(curso)
          }
        }
      );
      if (clases.length > 0) {
        res.json(clase);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Clases de la Empresa indicada',
        //     data: clases
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Clases registradas de la Empresa indicada'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Clases',
          error
        }
      );
    }
  },

  async getClaseById(req, res) {
    try {
      const { id } = req.params;
      const clase = await prisma.clase.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (clase !== null) {
        res.json(clase);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Clase encontrada',
        //     data: clase
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Clase con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Clase',
          error
        }
      );
    }
  },

  async updateClase(req, res) {
    try {
      const { id } = req.params;
      const { Nombre, Salon, Horario, idDocente, idPeriodo, idCurso } = req.body;
      const clase = await prisma.clase.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Nombre, Salon, Horario, idDocente, idPeriodo, idCurso }
        }
      );
      res.json(clase);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'Clase actualizada correctamente',
      //     data: clase
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Clase',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Clase
  // async deleteClase(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.clase.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'Clase eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Clase',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = ClaseController;
