const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const EstudianteController = {
  async createEstudiante(req, res) {
    try {
      const { NombreCompleto, Semestre, Firma, UsuarioId } = req.body;
      const estudiante = await prisma.estudiante.create(
        {
          data: { NombreCompleto, Semestre, Firma, UsuarioId }
        }
      );
      res.json(estudiante);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'Estudiante creada correctamente',
      //     data: estudiante
      //   }
      // );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Estudiante',
          error
        }
      );
    }
  },

  async getAllEstudiantes(req, res) {
    try {
      const estudiantes = await prisma.estudiante.findMany();
      if (estudiantes.length > 0) {
        res.json(estudiantes);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Estudiantes',
        //     data: estudiantes
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Estudiantes registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Estudiantes',
          error
        }
      );
    }
  },

  async getEstudianteByIdUsuario(req, res) {
    try {
      const { codigo } = req.params;
      const estudiante = await prisma.estudiante.findFirst(
        {
          where: {
            UsuarioId: parseInt(codigo)
          }
        }
      );
      if (estudiante !== null) {
        res.json(estudiante);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Estudiante encontrada',
        //     data: estudiante
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Estudiante con el id indicado'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Estudiante',
          error
        }
      );
    }
  },

  async getEstudianteById(req, res) {
    try {
      const { id } = req.params;
      const estudiante = await prisma.estudiante.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (estudiante !== null) {
        res.json(estudiante);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Estudiante encontrada',
        //     data: estudiante
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Estudiante con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Estudiante',
          error
        }
      );
    }
  },

  async updateEstudiante(req, res) {
    try {
      const { id } = req.params;
      const { NombreCompleto, Semestre, Firma, UsuarioId } = req.body;
      const estudiante = await prisma.estudiante.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { NombreCompleto, Semestre, Firma, UsuarioId }
        }
      );
      res.json(estudiante);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'Estudiante actualizada correctamente',
      //     data: estudiante
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Estudiante',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Estudiante
  // async deleteEstudiante(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.estudiante.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'Estudiante eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Estudiante',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = EstudianteController;
