const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const ExamenAuxiliarController = {
  async createExamenAuxiliar(req, res) {
    try {
      const { Contenido, FechaRegistro, PacienteId } = req.body;
      const examenauxiliar = await prisma.examenesAuxiliares.create(
        {
          data: { Contenido, FechaRegistro, PacienteId }
        }
      );
      // res.json(examenauxiliar);
      res.json(
        {
          status: 'success',
          msj: 'ExamenAuxiliar creada correctamente',
          data: examenauxiliar
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la ExamenAuxiliar',
          error
        }
      );
    }
  },

  async getAllExamenAuxiliars(req, res) {
    try {
      const examenesauxiliares = await prisma.examenesAuxiliares.findMany();
      if (examenesauxiliares.length > 0) {
        // res.json(examenesauxiliares);
        res.json(
          {
            status: 'success',
            msj: 'Lista de ExamenAuxiliars',
            data: examenesauxiliares
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay ExamenAuxiliars registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de ExamenAuxiliars',
          elerror: error
        }
      );
    }
  },

  async getExamenAuxiliarByPaciente(req, res) {
    try {
      const { codigo } = req.params;
      const examenesauxiliares = await prisma.examenesAuxiliares.findMany(
        {
          where: {
            PacienteId: parseInt(codigo)
          }
        }
      );
      if (examenesauxiliares.length > 0) {
        // res.json(examenesauxiliares);
        res.json(
          {
            status: 'success',
            msj: 'Lista de ExamenAuxiliars',
            data: examenesauxiliares
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay ExamenAuxiliars registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de ExamenAuxiliars',
          error
        }
      );
    }
  },

  async getExamenAuxiliarById(req, res) {
    try {
      const { id } = req.params;
      const examenauxiliar = await prisma.examenesAuxiliares.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (examenauxiliar !== null) {
        // res.json(examenauxiliar);
        res.json(
          {
            status: 'success',
            msj: 'ExamenAuxiliar encontrada',
            data: examenauxiliar
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la ExamenAuxiliar con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la ExamenAuxiliar',
          error
        }
      );
    }
  },

  async updateExamenAuxiliar(req, res) {
    try {
      const { id } = req.params;
      const { Contenido, FechaRegistro, PacienteId } = req.body;
      const examenauxiliar = await prisma.examenesAuxiliares.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Contenido, FechaRegistro, PacienteId }
        }
      );
      // res.json(examenauxiliar);
      res.json(
        {
          status: 'success',
          msj: 'ExamenAuxiliar actualizada correctamente',
          data: examenauxiliar
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la ExamenAuxiliar',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una ExamenAuxiliar
  // async deleteExamenAuxiliar(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.examenesAuxiliares.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'ExamenAuxiliar eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la ExamenAuxiliar',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = ExamenAuxiliarController;
