const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const NotasEvolutivasController = {
  async createNotasEvolutivas(req, res) {
    try {
      const { Fecha, Tratamiento, Firma, FechaRegistro, PacienteId } = req.body;
      const notaevolutiva = await prisma.notaEvolutiva.create(
        {
          data: { Fecha, Tratamiento, Firma, FechaRegistro, PacienteId }
        }
      );
      // res.json(notaevolutiva);
      res.json(
        {
          status: 'success',
          msj: 'NotasEvolutivas creada correctamente',
          data: notaevolutiva
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la NotasEvolutivas',
          error
        }
      );
    }
  },

  async getAllNotasEvolutivass(req, res) {
    try {
      const notasevolutivas = await prisma.notaEvolutiva.findMany();
      if (notasevolutivas.length > 0) {
        // res.json(notasevolutivas);
        res.json(
          {
            status: 'success',
            msj: 'Lista de NotasEvolutivass',
            data: notasevolutivas
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay NotasEvolutivass registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de NotasEvolutivass',
          error
        }
      );
    }
  },

  async getNotasEvolutivasByPaciente(req, res) {
    try {
      const { codigo } = req.params;
      const notasevolutivas = await prisma.notaEvolutiva.findMany(
        {
          where: {
            PacienteId: parseInt(codigo)
          }
        }
      );
      if (notasevolutivas.length > 0) {
        // res.json(notasevolutivas);
        res.json(
          {
            status: 'success',
            msj: 'Lista de NotasEvolutivass',
            data: notasevolutivas
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay NotasEvolutivass registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de NotasEvolutivass',
          error
        }
      );
    }
  },

  async getNotasEvolutivasById(req, res) {
    try {
      const { id } = req.params;
      const notaevolutiva = await prisma.notaEvolutiva.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (notaevolutiva !== null) {
        // res.json(notaevolutiva);
        res.json(
          {
            status: 'success',
            msj: 'NotasEvolutivas encontrada',
            data: notaevolutiva
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la NotasEvolutivas con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la NotasEvolutivas',
          error
        }
      );
    }
  },

  async updateNotasEvolutivas(req, res) {
    try {
      const { id } = req.params;
      const { Fecha, Tratamiento, Firma, FechaRegistro, PacienteId } = req.body;
      const notaevolutiva = await prisma.notaEvolutiva.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Fecha, Tratamiento, Firma, FechaRegistro, PacienteId }
        }
      );
      // res.json(notaevolutiva);
      res.json(
        {
          status: 'success',
          msj: 'NotasEvolutivas actualizada correctamente',
          data: notaevolutiva
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la NotasEvolutivas',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una NotasEvolutivas
  // async deleteNotasEvolutivas(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.notaEvolutiva.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'NotasEvolutivas eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la NotasEvolutivas',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = NotasEvolutivasController;
