const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const OdontogramaController = {
  async createOdontograma(req, res) {
    try {
      const { Nombre, Estado, Numero, PacienteId } = req.body;
      const odontograma = await prisma.odontograma.create(
        {
          data: { Nombre, Estado, Numero, PacienteId }
        }
      );
      res.json(odontograma);
      res.json(
        {
          status: 'success',
          msj: 'Odontograma creada correctamente',
          data: odontograma
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Odontograma',
          error
        }
      );
    }
  },

  async getAllOdontogramas(req, res) {
    try {
      const odontogramas = await prisma.odontograma.findMany();
      if (odontogramas.length > 0) {
        res.json(odontogramas);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Odontogramas',
        //     data: subcasosclinicos
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Odontogramas registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Odontogramas',
          error
        }
      );
    }
  },

  async getOdontogramaByPaciente(req, res) {
    try {
      const { codigo } = req.params;
      const odontogramas = await prisma.odontograma.findMany(
        {
          where: {
            PacienteId: parseInt(codigo)
          }
        }
      );
      if (odontogramas.length > 0) {
        res.json(odontogramas);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Odontogramas',
        //     data: odontogramas
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Odontogramas registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Odontogramas',
          error
        }
      );
    }
  },

  async getOdontogramaById(req, res) {
    try {
      const { id } = req.params;
      const odontograma = await prisma.odontograma.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (odontograma !== null) {
        res.json(odontograma);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Odontograma encontrada',
        //     data: odontograma
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Odontograma con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Odontograma',
          error
        }
      );
    }
  },

  async updateOdontograma(req, res) {
    try {
      const { id } = req.params;
      const { Nombre, Estado, Numero, PacienteId } = req.body;
      const odontograma = await prisma.odontograma.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Nombre, Estado, Numero, PacienteId }
        }
      );
      res.json(odontograma);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'Odontograma actualizada correctamente',
      //     data: odontograma
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Odontograma',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Odontograma
  // async deleteOdontograma(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.odontograma.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'Odontograma eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Odontograma',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = OdontogramaController;
