const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const PacienteController = {
  async createPaciente(req, res) {
    try {
      const { FechaCreacion, HoraCreacion, NumeroHistoriaClinica, Ectoscopia, 
        Nombre, ApellidoPaterno, ApellidoMaterno, Sexo, Lugar, Domicilio, 
        FechaNacimiento, EstadoCivil, NroCelular, Correo, Raza, GradoInstruccion, Ocupacion, 
        Responsable, ParentescoconResponsable, DomicilioResponsable, CelularResponsable,
        Acompaniante, EnfermedadActual, MotivoConsulta, FuncionesBiologicas, Orina, 
        Apetito, Suenio, Deposiciones, Sed, Alergias, AntecedentesAlergicos, 
        AntecedentesPersonal, AntecedentesFamiliar, AntecedentesPatologicos,
         UsuarioId, SedeId } = req.body;
      const paciente = await prisma.paciente.create(
        {
          data: { FechaCreacion, HoraCreacion, NumeroHistoriaClinica, Ectoscopia, 
            Nombre, ApellidoPaterno, ApellidoMaterno, Sexo, Lugar, Domicilio, 
            FechaNacimiento, EstadoCivil, NroCelular, Correo, Raza, GradoInstruccion, Ocupacion, 
            Responsable, ParentescoconResponsable, DomicilioResponsable, CelularResponsable,
            Acompaniante, EnfermedadActual, MotivoConsulta, FuncionesBiologicas, Orina, 
            Apetito, Suenio, Deposiciones, Sed, Alergias, AntecedentesAlergicos, 
            AntecedentesPersonal, AntecedentesFamiliar, AntecedentesPatologicos,
             UsuarioId, SedeId }
        }
      );
      res.js/on(paciente);
      res.json(
        {
          status: 'success',
          msj: 'Paciente creada correctamente',
          data: paciente
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Paciente',
          error
        }
      );
    }
  },

  async getAllPacientes(req, res) {
    try {
      const pacientes = await prisma.paciente.findMany(
        {
          include: {
            usuario: true,
            sede: true
          }
        }
      );
      if (pacientes.length > 0) {
        // res.json(pacientes);
        res.json(
          {
            status: 'success',
            msj: 'Lista de Pacientes',
            data: pacientes
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Pacientes registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Pacientes',
          error
        }
      );
    }
  },

  async getPacientesBySede(req, res) {
    try {
      const { codigo } = req.params;
      const pacientes = await prisma.paciente.findMany(
        {
          where: {
            SedeId: parseInt(codigo)
          },
          include: {
            usuario: true
          }
        }
      );
      if (pacientes.length > 0) {
        // res.json(pacientes);
        res.json(
          {
            status: 'success',
            msj: 'Lista de Pacientes',
            data: pacientes
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Pacientes en la sede escogida'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Pacientes',
          error
        }
      );
    }
  },

  async getPacientesByUsuario(req, res) {
    try {
      const { codigo } = req.params;
      const pacientes = await prisma.paciente.findMany(
        {
          where: {
            UsuarioId: parseInt(codigo)
          },
          include: {
            usuario: true,
            sede: true
          },
        }
      );
      if (pacientes.length > 0) {
        // res.json(pacientes);
        res.json(
          {
            status: 'success',
            msj: 'Lista de Pacientes',
            data: pacientes
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Pacientes en la sede escogida'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Pacientes',
          error
        }
      );
    }
  },

  async getPacienteByNumeroHistoriaClinica(req, res) {
    try {
      const { historiaclinica } = req.params;
      const paciente = await prisma.paciente.findUnique(
        {
          where: {
            NumeroHistoriaClinica: historiaclinica
          },
          include: {
            usuario: true,
            sede: true
          }
        }
      );
      if (paciente !== null) {
        // res.json(paciente);
        res.json(
          {
            status: 'success',
            msj: 'Paciente encontrada',
            data: paciente
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Paciente con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Paciente',
          error
        }
      );
    }
  },

  async getPacienteById(req, res) {
    try {
      const { id } = req.params;
      const paciente = await prisma.paciente.findUnique(
        {
          where: {
            id: parseInt(id)
          },
          include: {
            usuario: true,
            sede: true
          }
        }
      );
      if (paciente !== null) {
        // res.json(paciente);
        res.json(
          {
            status: 'success',
            msj: 'Paciente encontrada',
            data: paciente
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Paciente con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Paciente',
          error
        }
      );
    }
  },

  async updatePaciente(req, res) {
    try {
      const { id } = req.params;
      const { 
        FechaCreacion, HoraCreacion, NumeroHistoriaClinica, Ectoscopia, 
        Nombre, ApellidoPaterno, ApellidoMaterno, Sexo, Lugar, Domicilio, 
        FechaNacimiento, EstadoCivil, NroCelular, Correo, Raza, GradoInstruccion, Ocupacion, 
        Responsable, ParentescoconResponsable, DomicilioResponsable, CelularResponsable,
        Acompaniante, EnfermedadActual, MotivoConsulta, FuncionesBiologicas, Orina, 
        Apetito, Suenio, Deposiciones, Sed, Alergias, AntecedentesAlergicos, 
        AntecedentesPersonal, AntecedentesFamiliar, AntecedentesPatologicos,
         UsuarioId, SedeId } = req.body;
      const paciente = await prisma.paciente.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { 
            FechaCreacion, HoraCreacion, NumeroHistoriaClinica, Ectoscopia, 
        Nombre, ApellidoPaterno, ApellidoMaterno, Sexo, Lugar, Domicilio, 
        FechaNacimiento, EstadoCivil, NroCelular, Correo, Raza, GradoInstruccion, Ocupacion, 
        Responsable, ParentescoconResponsable, DomicilioResponsable, CelularResponsable,
        Acompaniante, EnfermedadActual, MotivoConsulta, FuncionesBiologicas, Orina, 
        Apetito, Suenio, Deposiciones, Sed, Alergias, AntecedentesAlergicos, 
        AntecedentesPersonal, AntecedentesFamiliar, AntecedentesPatologicos,
         UsuarioId, SedeId }
        }
      );
      // res.json(paciente);
      res.json(
        {
          status: 'success',
          msj: 'Paciente actualizada correctamente',
          data: paciente
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Paciente',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Paciente
  // async deletePaciente(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.paciente.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'Paciente eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Paciente',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = PacienteController;
