const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const PlanyCronogramaCompletoController = {
  async createPlanyCronogramaCompleto(req, res) {
    try {
      const { Fecha, Resumen, Especificaciones, Observaciones, FechaRegistro, PacienteId } = req.body;
      const plancompleto = await prisma.planyCronogramaCompleto.create(
        {
          data: { Fecha, Resumen, Especificaciones, Observaciones, FechaRegistro, PacienteId }
        }
      );
      // res.json(plancompleto);
      res.json(
        {
          status: 'success',
          msj: 'PlanyCronogramaCompleto creada correctamente',
          data: plancompleto
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la PlanyCronogramaCompleto',
          error
        }
      );
    }
  },

  async getAllPlanyCronogramaCompletos(req, res) {
    try {
      const planescompleto = await prisma.planyCronogramaCompleto.findMany();
      if (planescompleto.length > 0) {
        // res.json(planescompleto);
        res.json(
          {
            status: 'success',
            msj: 'Lista de PlanyCronogramaCompletos',
            data: planescompleto
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay PlanyCronogramaCompletos registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de PlanyCronogramaCompletos',
          error
        }
      );
    }
  },

  async getPlanyCronogramaCompletoByPaciente(req, res) {
    try {
      const { codigo } = req.params;
      const planescompleto = await prisma.planyCronogramaCompleto.findMany(
        {
          where: {
            PacienteId: parseInt(codigo)
          }
        }
      );
      if (planescompleto.length > 0) {
        // res.json(planescompleto);
        res.json(
          {
            status: 'success',
            msj: 'Lista de PlanyCronogramaCompletos',
            data: planescompleto
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay PlanyCronogramaCompletos registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de PlanyCronogramaCompletos',
          error
        }
      );
    }
  },

  async getPlanyCronogramaCompletoById(req, res) {
    try {
      const { id } = req.params;
      const plancompleto = await prisma.planyCronogramaCompleto.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (plancompleto !== null) {
        // res.json(plancompleto);
        res.json(
          {
            status: 'success',
            msj: 'PlanyCronogramaCompleto encontrada',
            data: plancompleto
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la PlanyCronogramaCompleto con el id indicado'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la PlanyCronogramaCompleto',
          error
        }
      );
    }
  },

  async updatePlanyCronogramaCompleto(req, res) {
    try {
      const { id } = req.params;
      const { Fecha, Resumen, Especificaciones, Observaciones, FechaRegistro, PacienteId } = req.body;
      const plancompleto = await prisma.planyCronogramaCompleto.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Fecha, Resumen, Especificaciones, Observaciones, FechaRegistro, PacienteId }
        }
      );
      // res.json(plancompleto);
      res.json(
        {
          status: 'success',
          msj: 'PlanyCronogramaCompleto actualizada correctamente',
          data: plancompleto
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la PlanyCronogramaCompleto',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una PlanyCronogramaCompleto
  // async deletePlanyCronogramaCompleto(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.planyCronogramaCompleto.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'PlanyCronogramaCompleto eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la PlanyCronogramaCompleto',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = PlanyCronogramaCompletoController;
