const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const PruebaOperariaController = {
  async createPruebaOperaria(req, res) {
    try {
      const { Nombre, PruebaId, OperatoriaId } = req.body;
      const pruebaoperaria = await prisma.pruebaOperaria.create(
        {
          data: { Nombre, PruebaId, OperatoriaId }
        }
      );
      // res.json(pruebaoperaria);
      res.json(
        {
          status: 'success',
          msj: 'PruebaOperaria creada correctamente',
          data: pruebaoperaria
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la PruebaOperaria',
          error
        }
      );
    }
  },

  async getAllPruebaOperarias(req, res) {
    try {
      const pruebasoperaria = await prisma.pruebaOperaria.findMany();
      if (pruebasoperaria.length > 0) {
        // res.json(pruebasoperaria);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de PruebaOperarias',
        //     data: pruebasoperaria
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay PruebaOperarias registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de PruebaOperarias',
          error
        }
      );
    }
  },

  async getPruebaOperariaByOperatoria(req, res) {
    try {
      const { codigo } = req.params;
      const pruebasoperaria = await prisma.pruebaOperaria.findMany(
        {
          where: {
            OperatoriaId: parseInt(codigo)
          }
        }
      );
      if (pruebasoperaria.length > 0) {
        // res.json(pruebasoperaria);
        res.json(
          {
            status: 'success',
            msj: 'Lista de PruebaOperarias',
            data: pruebasoperaria
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay PruebaOperarias registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de PruebaOperarias',
          error
        }
      );
    }
  },

  async getPruebaOperariaById(req, res) {
    try {
      const { id } = req.params;
      const pruebaoperaria = await prisma.pruebaOperaria.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (pruebaoperaria !== null) {
        // res.json(pruebaoperaria);
        res.json(
          {
            status: 'success',
            msj: 'PruebaOperaria encontrada',
            data: pruebaoperaria
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la PruebaOperaria con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la PruebaOperaria',
          error
        }
      );
    }
  },

  async updatePruebaOperaria(req, res) {
    try {
      const { id } = req.params;
      const { Nombre, PruebaId, OperatoriaId } = req.body;
      const pruebaoperaria = await prisma.pruebaOperaria.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Nombre, PruebaId, OperatoriaId }
        }
      );
      // res.json(pruebaoperaria);
      res.json(
        {
          status: 'success',
          msj: 'PruebaOperaria actualizada correctamente',
          data: pruebaoperaria
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la PruebaOperaria',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una PruebaOperaria
  // async deletePruebaOperaria(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.pruebaOperaria.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'PruebaOperaria eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la PruebaOperaria',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = PruebaOperariaController;
