const express = require('express');
const router = express.Router();
const CasoDienteController = require('../controllers/casodiente.controller');

// GET all CasoDientes
router.get('/', CasoDienteController.getAllCasoDientes);

// GET CasoDiente by id
router.get('/:id', CasoDienteController.getCasoDienteById);

// POST a new CasoDiente
router.post('/create', CasoDienteController.createCasoDiente);

// PUT update an existing CasoDiente
router.put('/update/:id', CasoDienteController.updateCasoDiente);

// DELETE an existing CasoDiente
// muy probable no considerar esta opción
// router.delete('/:id', CasoDienteController.deleteCasoDiente);

// para los filtros de CasoDiente
router.get('/subcasoclinico/:codigo', CasoDienteController.getCasoDienteBySubCasoClinico);

// para los filtros de CasoDiente
router.get('/diente/:codigo', CasoDienteController.getCasoDienteByDiente);

module.exports = router;
