const express = require('express');
const router = express.Router();
const DiagnosticoPresuntivoController = require('../controllers/diagnosticopresuntivo.controller');

// GET all DiagnosticoPresuntivos
router.get('/', DiagnosticoPresuntivoController.getAllDiagnosticoPresuntivos);

// GET DiagnosticoPresuntivo by id
router.get('/:id', DiagnosticoPresuntivoController.getDiagnosticoPresuntivoById);

// POST a new DiagnosticoPresuntivo
router.post('/create', DiagnosticoPresuntivoController.createDiagnosticoPresuntivo);

// PUT update an existing DiagnosticoPresuntivo
router.put('/update/:id', DiagnosticoPresuntivoController.updateDiagnosticoPresuntivo);

// DELETE an existing DiagnosticoPresuntivo
// muy probable no considerar esta opción
// router.delete('/:id', DiagnosticoPresuntivoController.deleteDiagnosticoPresuntivo);

// para los filtros de DiagnosticoPresuntivo
router.get('/search/paciente/:codigo', DiagnosticoPresuntivoController.getDiagnosticoPresuntivoByPaciente);

module.exports = router;
