const express = require('express');
const router = express.Router();
const DienteController = require('../controllers/diente.controller');

// GET all Dientes
router.get('/', DienteController.getAllDientes);

// GET Diente by id
router.get('/:id', DienteController.getDienteById);

// POST a new Diente
router.post('/create', DienteController.createDiente);

// PUT update an existing Diente
router.put('/update/:id', DienteController.updateDiente);

// DELETE an existing Diente
// muy probable no considerar esta opción
// router.delete('/:id', DienteController.deleteDiente);

module.exports = router;
