const express = require('express');
const router = express.Router();
const EndodonciaController = require('../controllers/endodoncia.controller');

// GET all Endodoncias
router.get('/', EndodonciaController.getAllEndodoncias);

// GET Endodoncia by id
router.get('/:id', EndodonciaController.getEndodonciaById);

// POST a new Endodoncia
router.post('/create', EndodonciaController.createEndodoncia);

// PUT update an existing Endodoncia
router.put('/update/:id', EndodonciaController.updateEndodoncia);

// DELETE an existing Endodoncia
// muy probable no considerar esta opción
// router.delete('/:id', EndodonciaController.deleteEndodoncia);

// para los filtros de Endodoncia
router.get('/search/paciente/:codigo', EndodonciaController.getEndodonciaByPaciente);

module.exports = router;
