const express = require('express');
const router = express.Router();
const EstudianteController = require('../controllers/estudiante.controller');

// GET all Estudiantes
router.get('/', EstudianteController.getAllEstudiantes);

// GET Estudiante by id
router.get('/:id', EstudianteController.getEstudianteById);

// POST a new Estudiante
router.post('/create', EstudianteController.createEstudiante);

// PUT update an existing Estudiante
router.put('/update/:id', EstudianteController.updateEstudiante);

// DELETE an existing Estudiante
// muy probable no considerar esta opción
// router.delete('/:id', EstudianteController.deleteEstudiante);

// para los filtros de Estudiante
router.get('/usuario/:codigo', EstudianteController.getEstudianteByIdUsuario);

module.exports = router;
