const express = require('express');
const router = express.Router();
const ExamenGeneralController = require('../controllers/examengeneral.controller');

// GET all ExamenGenerals
router.get('/', ExamenGeneralController.getAllExamenGenerals);

// GET ExamenGeneral by id
router.get('/:id', ExamenGeneralController.getExamenGeneralById);

// POST a new ExamenGeneral
router.post('/create', ExamenGeneralController.createExamenGeneral);

// PUT update an existing ExamenGeneral
router.put('/update/:id', ExamenGeneralController.updateExamenGeneral);

// DELETE an existing ExamenGeneral
// muy probable no considerar esta opción
// router.delete('/:id', ExamenGeneralController.deleteExamenGeneral);

// para los filtros de ExamenGeneral
router.get('/search/paciente/:codigo', ExamenGeneralController.getExamenGeneralByPaciente);

module.exports = router;
