const express = require('express');
const router = express.Router();
const IntegranteController = require('../controllers/integrante.controller');

// GET all Integrantes
router.get('/', IntegranteController.getAllIntegrantes);

// GET Integrante by id
router.get('/:id', IntegranteController.getIntegranteById);

// POST a new Integrante
router.post('/create', IntegranteController.createIntegrante);

// PUT update an existing Integrante
router.put('/update/:id', IntegranteController.updateIntegrante);

// DELETE an existing Integrante
// muy probable no considerar esta opción
// router.delete('/:id', IntegranteController.deleteIntegrante);

// para los filtros de Integrante

router.get('/clase/:codigo', IntegranteController.claseIntegrante);

// para los filtros de Integrante
router.get('/estudiante/:codigo', IntegranteController.estudianteIntegrante);

module.exports = router;
