const express = require('express');
const router = express.Router();
const PlandeTrabajoController = require('../controllers/plandetrabajo.controller');

// GET all PlandeTrabajos
router.get('/', PlandeTrabajoController.getAllPlandeTrabajos);

// GET PlandeTrabajo by id
router.get('/:id', PlandeTrabajoController.getPlandeTrabajoById);

// POST a new PlandeTrabajo
router.post('/create', PlandeTrabajoController.createPlandeTrabajo);

// PUT update an existing PlandeTrabajo
router.put('/update/:id', PlandeTrabajoController.updatePlandeTrabajo);

// DELETE an existing PlandeTrabajo
// muy probable no considerar esta opción
// router.delete('/:id', PlandeTrabajoController.deletePlandeTrabajo);

// para los filtros de PlandeTrabajo
router.get('/search/operatorio/:codigo', PlandeTrabajoController.getPlandeTrabajoByOperatoria);

module.exports = router;
