-- crear usuarios
-- datos extras cie 10 0 cie 11
-- Esto tiene la importancia del cie, depende de cuantos valores se encuentre en la página
-- 20 diagnósticos
INSERT INTO public."Diagnostico"("Tipo", "Codigo", "Resumen", "Descripcion")
VALUES ('CIE10', 'K02.9', 'Caries dental, no especificada', 'Daño a los dientes causado por caries dental sin especificar la localización.'),
('CIE10', 'K05.1', 'Gingivitis crónica', 'Inflamación crónica de las encías.'),
('CIE10', 'K10.1', 'Dolor orofacial', 'Dolor que involucra la boca y la cara.'),
('CIE10', 'K11.7', 'Trastornos de las glándulas salivales', 'Problemas relacionados con las glándulas salivales.'),
('CIE10', 'K12.2', 'Estomatitis vesicular', 'Inflamación con formación de vesículas en la mucosa oral.'),
('CIE10', 'K20.9', 'Enfermedad por reflujo gastroesofágico sin esofagitis', 'Retorno del contenido gástrico al esófago sin inflamación.'),
('CIE10', 'K22.7', 'Disfagia orofaríngea', 'Dificultad para tragar que afecta la garganta.'),
('CIE10', 'K29.0', 'Gastritis aguda', 'Inflamación aguda del revestimiento del estómago.'),
('CIE10', 'K30', 'Dispepsia', 'Dolor o malestar en la parte superior del abdomen.'),
('CIE10', 'K03.0', 'Exodoncia de diente deciduo', 'Extracción de un diente de leche.'),
('CIE10', 'K04.0', 'Gingivitis asociada con ortodoncia', 'Inflamación de las encías causada por ortodoncia.'),
('CIE10', 'K06.0', 'Anomalías de la erupción de los dientes', 'Problemas en la erupción normal de los dientes.'),
('CIE10', 'K08.1', 'Retención y falta de erupción de los dientes', 'Problemas con la erupción o el crecimiento de los dientes.'),
('CIE10', 'K09.9', 'Otros trastornos especificados de la boca y de los dientes', 'Problemas bucales y dentales no especificados de otra manera.'),
('CIE10', 'K11.0', 'Hipertrofia de las papilas filiformes', 'Agrandamiento de las estructuras en la lengua.'),
('CIE10', 'K14.0', 'Enfermedad por reflujo gastroesofágico con esofagitis', 'Retorno del contenido gástrico al esófago con inflamación.'),
('CIE10', 'K13.1', 'Ulceración de la lengua', 'Formación de úlceras en la lengua.'),
('CIE10', 'K07.6', 'Anomalías dentofaciales', 'Problemas en el desarrollo de la cara y los dientes.'),
('CIE10', 'K01.1', 'Dientes incluidos', 'Dientes que no han erupcionado normalmente.'),
('CIE10', 'K07.6', 'Anomalías dentofaciales', 'Problemas en el desarrollo de la cara y los dientes.'),
--CIE11
('CIE11', 'QA00', 'Examen odontológico', 'Evaluación clínica de la salud bucal'),
('CIE11', 'QA01', 'Radiografía dental', 'Uso de imágenes para diagnosticar problemas dentales'),
('CIE11', 'DA00', 'Afecciones de los labios', 'Problemas que afectan a los labios');

--gestion de estudiante
-- dos cursos viendo la malla de la carrera
INSERT INTO public."Curso"("Nombre", "Semestre", "Malla")
VALUES ('Operatoria Dental I', 'V', '2018'),
	('Ortodoncia Básica', 'VII', '2018');

-- solo un valor la conti ☑
INSERT INTO public."Empresa"( "Ruc", "RazonSocial", "Representante")
VALUES ('20319363221', 'Universidad Continental S.A.C.', 'José Felipe Barrios Ipenza');

-- las 5 sede de la conti ☑
INSERT INTO public."Sede"( "Nombre", "Direccion", "Celular", "Correo", "TipoSede", "EmpresaId")
VALUES ('Campus Huancayo', 'Av. San Carlos 1980 de la Urb. San Antonio.', '(064) 481430', 'centrodeatencion@continental.edu.pe', 'Huancayo', 1),
('Campus Lima', 'Av. Alfredo Mendiola 5210, Los Olivos', '(01) 2132760', 'centrodeatencion@continental.edu.pe', 'Lima', 1),
('Campus Cusco', 'Sector Angostura km. 10, en San Jerónimo.', '(084) 480070', 'centrodeatencion@continental.edu.pe', 'Cusco', 1),
('Campus Arequipa', 'José Luis Bustamante y Rivero, en la Ciudad Blanca', '(054) 412030', 'centrodeatencion@continental.edu.pe', 'Arequipa', 1),
('Campus Lima', 'Calle Junín 355, Miraflores', '(01) 2132760', 'centrodeatencion@continental.edu.pe', 'Lima', 1);

-- un periodo por sede el actual 2022-2
INSERT INTO public."Periodo"("Nombre", "Empieza", "Termina", "SedeId")
VALUES ('2023-2', '2023-08-21', '2023-12-09', 1),
('2023-2', '2023-08-21', '2023-12-10', 2),
('2023-2', '2023-08-21', '2023-12-10', 3),
('2023-2', '2023-08-21', '2023-12-10', 4),
('2023-2', '2023-08-21', '2023-12-10', 5);

-- dos clases por curso con el periodo actual
INSERT INTO public."Clase"("Nombre", "Salon", "Horario", "idDocente", "idPeriodo", "idCurso")
VALUES ('Ortodoncia Básica', 'H101', '7:30', 0, 1, 2),
 ('Ortodoncia Básica', 'H101', '11:30', 0, 1, 2),
('Operatoria Dental I', 'H102', '17:50', 0, 1, 1),
('Operatoria Dental I', 'H102', '15::30', 0, 1, 1);

-- poner la gran mayoria a los que pertenezcan a la sede hyo
-- el nombre sera nrc-estudiante
INSERT INTO public."Integrante"("Nombre", "ClaseId", "EstudianteId")
VALUES ('40233-', 1, 1),
('41343- ', 1, 1),
('32232- ', 2, 1),
('40210-', 1, 1),
('43002- ', 1, 1),
('40201-', 1, 1),
('41123- ', 1,1 ),
('332122-', 2, 1),
('30213-', 2, 1),
('4025-', 1, 1);

--historia clinica
-- solo 5 pacientes
INSERT INTO public."Paciente"("FechaCreacion", "HoraCreacion", "NumeroHistoriaClinica",
"Ectoscopia", "Nombre", "ApellidoPaterno", "ApellidoMaterno", "Sexo", "Lugar",
"Domicilio", "FechaNacimiento", "EstadoCivil", "NroCelular", "Correo", "Raza",
"GradoInstruccion", "Ocupacion", "Responsable", "ParentescoconResponsable",
"DomicilioResponsable", "CelularResponsable", "Acompaniante", "EnfermedadActual",
"MotivoConsulta", "FuncionesBiologicas", "Orina", "Apetito", "Suenio",
"Deposiciones", "Sed", "Alergias", "AntecedentesAlergicos", "AntecedentesPersonal",
"AntecedentesFamiliar", "AntecedentesPatologicos", "SedeId", "EstudianteId" )
VALUES ('2023-06-15', '15:30', '1', 'Paciente masculino de 30 años aparentemente en buen estado general', 'Esteban', 'Flores', 'Paredes', 'M', 'Huancayo', 'Av. Los Andes 123, Urb. San Martin', '1990-05-15', 'Soltero', '987123456', 'esteban.flores@gmail.com', 'Oscura', 'Educación terciaria(Universitaria o técnica) completa', 'Ingeniero', 'Cristina Flores', 'Prima', 'Av. Los Andes 123, Urb. San Martin', '923172022', 'Ninguna', 'Dolor de muela', ' ”Me duele muy fuerte en mi diente al comer algo dulce” ', 'Normal', 'Conservado', 'Conservado(03 veces al dia)', 'Conservado' ,'Conservado(02 veces al dia)','Conservado(05 vasos al dia)','Ninguna', 'No refiere', 'No refiere', 'Padre: Diabetes, Madre: Hipertensión', 'Hipertensión, Asma',1, 1),
('2023-06-15', '15:56', '2', 'Paciente femenina de 44 años aparentemente en ABEG, ABEN, ABEH y LOTEP', 'Alejandra', 'Gutierrez', 'Rocha', 'F', 'Huancayo', 'Jr. Las Flores 123', '1979-05-15', 'Soltera', '924954880', 'alejandra.gutierrez@gmail.com', 'Blanca', 'Educación secundaria incompleta', 'Ama de casa', 'Karen Rocha Aliaga', 'Madre', 'Jr. Las Flores 123', '953142222', 'Ninguna', 'Paciente mujer de 44 años de edad refiere que hace aproximadamente 02 años empezó a sentir dolor incomodidad en la parte posterior de la cavidad bucal al masticar algunos alimentos duros y cuando los alimentos no está bien triturados, siente dolor de estómago, el dolor inició de forma brusca al morder alimentos duros y ha sido progresiva porque va en aumento. El dolor es provocado al momento de masticar. El dolor empieza en un lugar específico y luego se va exponiendo por toda la cavidad', ' ”No puedo masticar los alimentos” ', 'Normal', 'Conservado', 'Conservado(05 veces al dia)', 'Conservado','Conservado(02 veces al dia)', 'Conservado(07 vasos al dia)', 'No refiere', 'No refiere', 'Alimentación: consume alimentos balanceados', 'Padre fallecido hace 2 años,  a las 75 años, estaba diagnosticado de tiroides. Madre viva de 68 años aparentemente sana, hija viva de 68 años aparentemente sana',1, 1),
('2023-06-16', '10:56', '3', 'Paciente masculino de 30 años aparentemente en buen estado general', 'Carlos', 'Martínez', 'Gómez', 'M', 'Huancayo', 'Av. Principal 456', '1993-07-12', 'Casado', '911021800', 'carlos.martinez@gmail.com', 'Mestizo', 'Educación terciaria(Universitaria o técnica) completa', 'Ingeniero', 'Laura Gomez', 'Esposa', 'Av. Principal 456', '951128902', 'Juan Perez', 'Consulta por dolor de muelas', 'olor agudo en la muela superior derecha al masticar', 'Normal', 'Conservado','Conservado(03 veces al dia)', 'Conservado', 'Conservado(01 veces al dia)','Conservado 05 vasos al dia)','No refiere', 'No Refiere', 'Ninguna', 'No refiere', 'Ninguno muy significativo',1, 1),
('2023-06-16', '16:15', '4', 'Paciente femenina de 28 años aparentemente en buen estado', 'Maria', 'Hernandez', 'Gómez', 'F', 'Huancayo', 'Calle Secundaria 456', '1995-08-12', 'Casada', '987654321', 'maria.hernandez@gmail.com', 'Mestizo', 'Educación terciaria(Universitaria o técnica) completa', 'Ingeniero', 'Juan Gomez', 'Hermana', 'Calle Secundaria 456', '998877665', 'Hermana', 'Ningunal', '”Deseo una limpieza dental”', 'Normal', 'Conservado','Conservado(03 veces al dia)', 'Conservado', 'Conservado(02 veces al dia)','Conservado(09 vasos al dia)','No refiere', 'No Refiere', 'Ninguna', 'No refiere', 'Ninguno muy significativo',1, 1),
('2023-06-17', '9:15', '5', 'Paciente femenina de 32 años aparentemente en buen estado', 'Laura', 'Rodriguez', 'Santos', 'F', 'Huancayo', 'Jr. trujillo 45', '1991-11-21', 'Divorciada', '932456789', 'laura.rodriguez@gmail.com', 'Mestiza', 'Educacion terciaria(Universitaria o tecnica) completa', 'Inginiera', 'Carlos Santos', 'Padre', 'Jr. trujillo 45', '918875661', 'Amiga', 'Consulta po el dolor de muelas al masticar', '”No puedo masticar los alimento por el dolor que siento ”', 'Normal', 'Conservado','Conservado(03 veces al dia)', 'Conservado', 'Conservado(02 veces al dia)','Conservado(02 vasos al dia)','No refiere', 'No Refiere', 'Ninguna', 'No refiere', 'Ninguno muy significativo',1, 1);
-- para cada paciente
INSERT INTO public."ExamenGeneral"("Peso", "Talla", "IndiceMasaCorporal", "Piel", "AnexoCabello", "AnexoUnias", "PresionArterial",  "FrecuenciaRespiratoria", "Pulso", "Temperatura", "PacienteId")
VALUES ('70.5 kg', '175 cm', '23.3(peso normal)', 'Oscura', 'Negro', 'Mano derecha', '120/80', '16-20 respiraciones por minuto', '75', '36.5°C', 1),
('63 kg', '155 cm', ' 26.2 (sobrepeso)', 'Hidratada y con buena elasticidad', 'Buena implantación, distribución pilosa y con una notable higiene', 'Tamaño promedio, sin lesiones, con buena higiene y excelente llenado capilar', '110/70 mmHg', '16 rpm', '84 ppm', '36.1°C', 2),
('78.5 kg', '180 cm', '27.2 (sobrepeso)', 'Oscura', 'Negro', 'Mano derecha', '130/85', '18-22 respiraciones por minuto', '80', '37.2°C', 3),
('65 kg', '165 cm', '28.2 (sobrepeso)', 'Clara', 'Castaño', 'Mano derecha y izquierda', '119/80', '16-20 respiraciones por minuto', '74', '36.8°C', 4),
('70 kg', '170 cm', 'Normal', 'Clara', 'Castaño', 'Mano izquierda', '130/85', '18-22 respiraciones por minuto', '80', '37.0°C', 5);

-- para cada paciente
INSERT INTO public."Anamnesis"("Contenido", "FechaRegistro", "PacienteId")
VALUES ('El paciente ha experimentado sensibilidad al comer alimentos fríos. No hay problemas de respiración ni otras molestias relacionadas.', '2023-06-15', 1),
('La paciente refiere haber experimentado molestias en la cavidad bucal al masticar alimentos duros durante los últimos dos años. El dolor ha ido aumentando progresivamente y se extiende por toda la cavidad bucal. Además, menciona sentir dolor de estómago cuando los alimentos no están bien triturados. El dolor inició bruscamente al morder alimentos duros. La paciente manifiesta incapacidad para masticar adecuadamente los alimentos.', '2023-06-15', 2),
('Consulta por dolor de muelas. Dolor agudo en la muela superior derecha al masticar.', '2023-06-16',3),
('Consulta por limpieza dental. Deseo una limpieza dental.', '2023-06-16', 4),
('Consulta por dolor de muelas al masticar. No puedo masticar los alimentos por el dolor que siento.', '2023-06-17', 5);

-- para cada paciente
INSERT INTO public."DiagnosticoDefinitivo"("Diagnostico", "FechaRegistro", "PacienteId")
VALUES ('Caries dental en la muela superior derecha', '2023-06-15', 1),
('Dolor bucal al masticar alimentos duros con progresión y molestias estomacales asociadas', '2023-06-15', 2),
('Caries en muela superior derecha', '2023-06-16', 3),
('Necesidad de limpieza dental', '2023-06-16', 4),
('Caries en muela inferior izquierda', '2023-06-17', 5);

-- para cada paciente
INSERT INTO public."DiagnosticoPresuntivo"("Diagnostico", "FechaRegistro", "PacienteId")
VALUES ('Hay una posible infección en la encía inferior izquierda', '2023-06-15', 1),
('Posible afectación dental relacionada con dolor al masticar alimentos duros', '2023-06-15', 2),
('Posible caries en muela superior derecha', '2023-06-16', 3),
('Posible necesidad de limpieza dental', '2023-06-16', 4),
('Posible caries en muela inferior izquierda', '2023-06-17', 5);

-- para cada paciente
INSERT INTO public."ExamenesAuxiliares"("Contenido", "FechaRegistro", "PacienteId")
VALUES ('Radiografía panorámica dental muestra signos de caries en varias muelas', '2023-06-15', 1),
('Radiografía panorámica dental realizada para evaluar posibles problemas en la cavidad bucal', '2023-06-15', 2),
('Radiografía panorámica dental solicitada para evaluar muela superior derecha', '2023-06-16', 3),
('Radiografía panorámica dental solicitada para evaluar necesidad de limpieza dental', '2023-06-16', 4),
('Radiografía panorámica dental solicitada para evaluar muela inferior izquierda', '2023-06-17', 5);

-- para cada paciente
INSERT INTO public."Epicrisis"("Contenido", "FechaRegistro", "PacienteId")
VALUES ('Se completó el tratamiento para las caries dentales', '2023-06-15', 1),
('La paciente ha sido diagnosticada con dolor en la cavidad bucal al masticar alimentos duros. Se recomienda tratamiento para aliviar el dolor y se programan citas de seguimiento.', '2023-06-15', 2),
('Paciente masculino de 30 años atendido por dolor agudo en la muela superior derecha. Se solicitó radiografía panorámica dental para evaluar la condición.', '2023-06-16', 3),
('Paciente femenina de 28 años atendida por la solicitud de limpieza dental. Se revisaron radiografías panorámicas dentales para evaluar la salud bucal.', '2023-06-16', 4),
('Paciente femenina de 32 años atendida por dolor al masticar. Se le realizo una radiografia panoramica dental para evaluar la muela inferior izquierda', '2023-06-17', 5);

-- para cada paciente
INSERT INTO public."PlanyCronogramaCompleto"("Fecha", "Resumen", "Especificaciones", "Observaciones", "FechaRegistro", "PacienteId")
VALUES ('2023-06-15', 'Plan de tratamiento para restauración dental', 'Programar limpieza dental y realizar empastes en molar superior e inferior', 'Ninguna', '2023-06-15 15:20', 1),
('2023-06-15 14:00', 'Tratamiento para dolor en cavidad bucal', 'Realizar radiografías para evaluar posibles problemas dentales', 'Programar seguimiento mensual para evaluar progresión del tratamiento', '2023-06-15 13:25', 2),
('2023-06-16', 'Tratamiento dental', 'Realizar una obturación en la muela superior derecha', 'Requiere anestesia local y verificación de la condición de la raíz', '2023-06-16 13:00', 3),
('2023-06-16', 'Limpieza dental', 'Realizar una limpieza profunda de la boca', 'Recomendar cuidados de higiene bucal', '2023-06-16 19:30', 4),
('2023-06-17', 'Evaluación dental', 'Revisar la muela inferior izquierda', 'Evaluar la necesidad de tratamiento adicional', '2023-06-17 11:30', 5);

-- para cada paciente
INSERT INTO public."NotaEvolutiva"("Fecha", "Tratamiento", "Firma", "FechaRegistro", "PacienteId")
VALUES ('2023-06-20', 'Continuación del tratamiento para caries dentales', wasa, '2023-06-20', 1),
('2023-06-15', 'Continuar con el tratamiento para el dolor en cavidad bucal', wasa, '2023-06-15', 2),
('2023-06-16', 'Se realizó la obturación en la muela superior derecha', wasa, '2023-06-16 14:30', 3),
('2023-06-16', 'Se realizó la limpieza dental. Recomendado mantener una buena higiene bucal', wasa, '2023-06-16 20:15', 4),
('2023-06-17', 'Se realizó la evaluación de la muela inferior izquierda. No se requiere tratamiento adicional por el momento', wasa, '2023-06-17 12:15', 5);

-- para cada paciente
INSERT INTO public."Interpretacion"("RadiografiaPanoramica", "HemogramaCompleto", "TiempoSangria", "TiempoCoagulacion", "FechaRegistro", "PacienteId")
VALUES ('Los resultados son normales, no se observa ninguna anomalía', 'El hemograma está dentro de los rangos normales', '5 minutos, dentro del rango normal', '8 minutos, dentro del rango normal', '2023-06-15', 1),
('Normal', 'Dentro de los rangos normales', '5 minutos', '10 minutos', '2023-06-15', 2),
('Las radiografías panorámicas muestran una condición general de salud dental aceptable.', 'Los resultados del hemograma completo están dentro de los rangos normales.', 'El tiempo de sangría es normal', 'El tiempo de coagulación es normal', '2023-06-16 15:30', 3),
('Se observan algunas irregularidades en las radiografías panorámicas que requieren mas evaluación.', 'Los resultados del hemograma completo están dentro de los rangos normales.', 'El tiempo de sangría es normal', 'El tiempo de coagulación es normal', '2023-06-16 21:00', 4),
('Las radiografías panorámicas no muestran anomalías significativas', 'Los resultados del hemograma completo están dentro de los rangos normales.', 'El tiempo de sangría es normal', 'El tiempo de coagulación es normal', '2023-06-17 13:45', 5);

--gestión del odontograma
-- los 32 dientes que tiene el ser humano
-- en tipo poner los que son de leche y los definitivos
INSERT INTO public."Diente"("Nombre", "Ubicación", "Tipo", "Lado", "Posición", "Raiz", "Estado")
	VALUES 
-- Incisivo
('Incisivo Central Superior Derecho', '11', Incisivo, 'Derecho', 'Arriba', '1', Permanente),
('Incisivo Lateral Superior Derecho', '12 ', Incisivo, 'Derecho', 'Arriba', '1', Permanente),
('Incisivo Central Inferior Derecho', '41', Incisivo, 'Derecho',   'Abajo', '1', Permanente),
('Incisivo Lateral Inferior Derecho', '42', Incisivo, 'Derecho',  'Abajo', '1', Permanente),
('Incisivo Central Superior Izquierdo', '21', Incisivo, 'Izquierdo', 'Arriba', '1', Permanente),
('Incisivo Lateral Superior Izquierdo', '22', Incisivo, 'Izquierdo', 'Arriba', '1', Permanente),
('Incisivo Central Inferior Izquierdo', '31', Incisivo, 'Izquierdo', 'Abajo', '1', Permanente),
('Incisivo Lateral Inferior Izquierdo', '32', Incisivo, 'Izquierdo', 'Abajo', '1', Permanente),
-- Canino
('Canino Superior Derecho', '13' , 'Canino', 'Derecho', 'Arriba', '1', Permanente),
('Canino Inferior Derecho', '43', 'Canino', 'Derecho', 'Abajo', '1', Permanente),
('Canino Superior Izquierdo', '23', 'Canino', 'Izquierdo', 'Arriba', '1', Permanente),
('Canino Inferior Izquierdo', '33', 'Canino', 'Izquierdo', 'Abajo', '1', Permanente),
-- Premolares
('Primer Premolar Superior Derecho', '14', Premolar, 'Derecho', 'Arriba', '2', Permanente),
('Segundo Premolar Superior Derecho', '15', Premolar, 'Arriba', 'Arriba', '2', Permanente),
('Primer Premolar Inferior Derecho', '44', Premolar, 'Derecho', 'Abajo', '2', Permanente),
('Segundo Premolar Inferior Derecho', '45', Premolar, 'Derecho', 'Abajo', '2', Permanente),
('Primer Premolar Superior Izquierdo', '24', Premolar, 'Izquierdo', 'Arriba', '2', Permanente),
('Segundo Premolar Superior Izquierdo', '25', Premolar, 'Izquierdo', 'Arriba', '2', Permanente),
('Primer Premolar Inferior Izquierdo', '34', Premolar, 'Izquierdo', 'Abajo', '2', Permanente),
('Segundo Premolar Inferior Izquierdo', '35', Premolar, 'Izquierdo', 'Abajo', '2', Permanente),
-- Molares
('Primer Molar Superior Derecho', '16', Molar, 'Derecho', 'Arriba', '3', Permanente),
('Segundo Molar Superior Derecho', '17', Molar, 'Derecho', 'Arriba', '3', Permanente),
('Tercer Molar Superior Derecho (Muela del Juicio)', '18', Molar, 'Derecho', 'Arriba', '3', Permanente),
('Primer Molar Inferior Derecho', '46', Molar, 'Derecho', 'Abajo', '2', Permanente),
('Segundo Molar Inferior Derecho', '47', Molar, 'Derecho', 'Abajo', '2', Permanente),
('Tercer Molar Inferior Derecho (Muela del Juicio)', '48', Molar, 'Derecho', 'Abajo', '2', Permanente),
('Primer Molar Superior Izquierdo', '26', Molar, 'Izquierdo', 'Arriba', '3', Permanente),
('Segundo Molar Superior Izquierdo', '27', Molar, 'Izquierdo', 'Arriba', '3', Permanente),
('Tercer Molar Superior Izquierdo (Muela del Juicio)', '28', Molar, 'Izquierdo', 'Arriba', '3', Permanente),
('Primer Molar Inferior Izquierdo', '36', Molar, 'Izquierdo', 'Abajo', '2', Permanente),
('Segundo Molar Inferior Izquierdo', '37', Molar, 'Izquierdo', 'Abajo', '2', Permanente),
('Tercer Molar Inferior Izquierdo (Muela del Juicio)', '38', Molar, 'Izquierdo', 'Abajo', '2', Permanente);



-- los 6 casos clinicos
INSERT INTO public."CasoClinico"("Nombre")
	VALUES ('Tratamiento de caries'),
('Extracción dental'),
('Endodoncia'),
('Fractura Dental'),
('Reabsorción Radicular'),
('Sellados de fosas y fisuras');

-- los subcasos clinicos de los 6 casos clinicos
INSERT INTO public."SubCasoClinico"("Nombre", "CasoClinicoId")
	VALUES ('Tratamiento de caries en diente definitivo ', 1),
('Extracción de diente definitivo ', 2),
('Tratamiento de conductos en diente definitivo ', 3),
('Fractura coronal del diente definitivo ', 4),
('Reabsorción radicular externa en diente definitivo ', 5),
('Sellado de fosas y fisuras en diente definitivo ', 6);

-- por cada subcaso se aniade a cada diente
-- incluyendo el diente sano
INSERT INTO public."CasoDiente"("Nombre", "Foto", "SubCasoClinicoId", "DienteId")
	VALUES ('Caries en Incisivo Central Superior Derecho', 'la foto del diente', 1, 1),
('Extracción del Primer Molar Superior Izquierdo', 'la foto del diente', 2, 27),
('Tratamiento de conductos en el Segundo Molar Superior Derecho', 'la foto del diente', 3, 22),
('Fractura coronal del Segundo Premolar Superior Izquierdo', 'la foto del diente', 4, 18),
('Reabsorción radicular externa del Primer Molar Superior Derecho', 'la foto del diente', 5, 21),
('Sellado de fosas y fisuras en el Tercer Molar Superior Izquierdo', 'la foto del diente', 6, 29);

-- 2 odontogramas
INSERT INTO public."Odontograma"("Nombre", "Estado", "Numero", "PacienteId")
	VALUES ('Odontograma de paciente  Esteban Flores', 'Activo', '1', 1),
('Odontograma de paciente  Alejandra Gutierrez', 'Activo', '1', 2),
('Odontograma con dolor molar', 'Activo', '1', 2),
('Molar Inferior Derecho', 'Conservado', '1', 2);


-- este mapeo trae 32 datos por cada odontograma
INSERT INTO public."Mapeo"("Nombre", "OdontogramaId", "CasodienteId")
	VALUES ('Diente con dolor', 1, 1),
 ('Diente con dolor', 2, 2),
('Incisivo Central Superior Derecho', 1, 1),
  ('Incisivo Lateral Superior Derecho', 1, 2),
  ('Incisivo Central Inferior Derecho', 1, 3),
  ('Incisivo Lateral Inferior Derecho', 1, 4),
  ('Incisivo Central Superior Izquierdo', 1, 5),
  ('Incisivo Lateral Superior Izquierdo', 1, 6),
  ('Incisivo Central Inferior Izquierdo', 1, 7),
  ('Incisivo Lateral Inferior Izquierdo', 1, 8),
('Canino Superior Derecho', 1, 9),
  ('Canino Inferior Derecho', 1, 10),
  ('Canino Superior Izquierdo', 1, 11),
  ('Canino Inferior Izquierdo', 1, 12),
('Primer Premolar Superior Derecho', 1, 13),
  ('Segundo Premolar Superior Derecho', 1, 14),
  ('Primer Premolar Inferior Derecho', 1, 15),
  ('Segundo Premolar Inferior Derecho', 1, 16),
  ('Primer Premolar Superior Izquierdo', 1, 17),
  ('Segundo Premolar Superior Izquierdo', 1, 18),
  ('Primer Premolar Inferior Izquierdo', 1, 19),
  ('Segundo Premolar Inferior Izquierdo', 1, 20),
('Primer Molar Superior Derecho', 1, 21),
  ('Segundo Molar Superior Derecho', 1, 22),
  ('Tercer Molar Superior Derecho (Muela del Juicio)', 1, 23),
  ('Primer Molar Inferior Derecho', 1, 24),
  ('Segundo Molar Inferior Derecho', 1, 25),
  ('Tercer Molar Inferior Derecho (Muela del Juicio)', 1, 26),
  ('Primer Molar Superior Izquierdo', 1, 27),
  ('Segundo Molar Superior Izquierdo', 1, 28),
  ('Tercer Molar Superior Izquierdo (Muela del Juicio)', 1, 29),
  ('Primer Molar Inferior Izquierdo', 1, 30),
  ('Segundo Molar Inferior Izquierdo', 1, 31),
  ('Tercer Molar Inferior Izquierdo (Muela del Juicio)', 1, 32);
-- por cada mapeo es uno
INSERT INTO public."CarasDiente"("Mesial", "Distal", "Vestibular", "Lingual", "Palatina", "MapeoId")
	VALUES ('Caries profunda', 'Sano', 'Caries superficial', 'Sano', 'Sano', 1),
 ('Sano', 'Leve desgaste', 'Sano', 'Caries profunda', 'Leve desgaste', 2),
 ('Sano', 'Sano', 'Dañado', 'Sano', 'Sano', 1),
 ('Sano', 'Sano', 'Sano', 'Sano', 'Sano', 1),
 ('Sano', 'Sano', 'Sano', 'Sano', 'Sano', 1);

--gestion operatorio
-- uno por paciente
INSERT INTO public."Operatoria"("Docente", "MotivoConsulta", "DiagnosticoDefinitivo", "PacienteId")
	VALUES ('Dr. Rosales', 'Caries en molar superior derecho', 'Obturación dental', 1),
 ('Dr. Rosales', 'Dolor al masticar alimentos duros', 'Caries profunda en molar superior izquierdo y Molar Inferior derecho', 2),
 ('Dr. Rosales', 'Consulta por dolor de muelas', 'Caries en molar superior derecho', 3),
 ('Dr. Rosales', 'Consulta por limpieza dental', 'requiere limpieza', 4),
 ('Dr. Rosales', 'Consulta por dolor de muelas al masticar', 'Caries en molar superior izquierdo y molar inferior derecho', 5);

INSERT INTO public."Prueba"("Nombre")
	VALUES ('Radiografía Panorámica'),
 ('Examen Táctil'),
 ('Tomografía Computarizada'),
('Radiografía Intraoral'),
 ('Examen Visual'),
 ('Examen Visual'),
 ('Examen Táctil');

INSERT INTO public."PruebaOperaria"("Nombre", "PruebaId", "OperatoriaId")
	VALUES ('Radiografia Panoramica', '1', 1),
('Radiografía Panorámica Preoperatoria', '2', 2),
('Radiografía Panorámica', '1', 3),
('Tomografía Computarizada', '3', 4),
('Radiografía Intraoral', '4', 5);

INSERT INTO public."TecnicaRadiografica"("NumeroPieza", "Detalle", "Tipo", "OperatoriaId")
	VALUES ('1', 'Radiografía peripical del molar superior derecho', 'Peripical', 1),
('1', 'Radiografía peripical', 'Intraoral', 2),
('18', 'Radiografía convencional de la muela del juicio', 'Periapical', 3),
('36', 'Radiografía digital del primer molar inferior izquierdo', 'Panorámica', 3),
('22', 'Radiografía digital del lateral superior izquierdo', 'Periapical', 4),
('47', 'Tomografía de haz cónico del segundo molar inferior derecho', 'Volumétrica', 4),
('33', 'Radiografía convencional del canino inferior izquierdo', 'Periapical', 4),
('14', 'Radiografía digital del primer premolar superior derecho', 'Bitewing', 4);

INSERT INTO public."PlandeTrabajo"("Cantidad", "TratamientoRestauracionconMaterialAdhesivo", "PiezaNumero", "TipodeMaterialRestaurador", "FechaRegistro", "OperatoriaId")
	VALUES ('1', 'Restauración con material adhesivo', '1', 'Composite', '2023-06-15', 1),
('1', 'Restauración con composite', '1', 'Composite A2', '2023-06-15', 2),
(2, 'Restauración con composite', '18', 'Composite A1', '2023-06-18 9:30', 3),
(1, 'Extracción', '32', 'N/A', '2023-06-18 9:30', 3),
(3, 'Endodoncia', '22', 'Gutta-percha', '2023-06-18 14:45', 4),
(1, 'Limpieza dental', '24', 'N/A', '2023-06-18 14:45', 4),
(1, 'Extracción', '33', 'N/A', '2023-06-19 10:15', 5),
(2, 'Restauración con amalgama', '14', 'Amalgama A3', '2023-06-19 10:15', 5);

--gestion cirugia
-- uno por paciente
INSERT INTO public."Cirugia"("MotivoConsulta", "DiagnosticoCIE11", "Pronostico", "PlandeTrabajo", "Cirujano", "Asistente", "Circulante", "HoradeInicioCx", "HoradeTerminoCx", "FechaAlta", "Observaciones", "EvolucionDiaria", "EstudianteaCargo", "FacultativoaCargo", "FechaRegistro", "PacienteId")
	VALUES ('Extracción de molar superior derecho', 'K02.2 - Caries dental en la dentina', 'Bueno', 'Restauración con material adhesivo', 'Dr. Rosales', 'Lic. Rodríguez', 'Enfermera Lopez', '15:40', '15:55', '2023-06-20', 'Sin complicaciones', 'Buena recuperación','Perez','Dr. Rosales', '2023-06-15 15:35:00', 1),
('Extracción de molar inferior derecho y molar superior derecho', 'K01.1', 'Bueno', 'Extracción molar', 'Dr. Rosales', 'Dra. Martinez', 'Enfermera Garcia', '9:00', '10:30', '2023-06-15', 'El paciente se recupera favorablemente', 'Normal','Estudiante Gomez','Dr. Rosales', '2023-06-15 11:30:00', 2),
('Dolor en muela superior derecha', 'K08.8', 'Bueno', 3, 'Dr. Juan', 'Dra. Maycol', 'Enfermera Laura', '2023-06-18 10:00', '2023-06-18 12:00', '2023-06-18 15:30', 'Sin complicaciones', 'Buena recuperación del paciente', 'Estudiante Flavio', 'Dr. Rosales', '2023-06-18 09:30', 3),
('Limpieza dental y endodoncia', 'K02.1', 'Bueno', 4, 'Dra. Maria', 'Dra. Sofia', 'Enfermera Laura', '2023-06-18 15:00', '2023-06-18 17:30', '2023-06-18 19:45', 'Sin complicaciones', 'Buena evolución postoperatoria', 'Estudiante Mary', 'Dr. Rosales', '2023-06-18 14:30', 4),
('Dolor en muela inferior izquierda', 'K08.8', 'Regular', 5, 'Dr. Rosales', 'Dra. Lucia', 'Enfermera Marta', '2023-06-19 11:00', '2023-06-19 13:30', '2023-06-19 17:15', 'Complicaciones leves', 'Requiere seguimiento postoperatorio', 'Estudiante Fernan', 'Dr. Rosales', '2023-06-19 10:30', 5);

INSERT INTO public."RadiografiaCirugia"("Fecha", "Nombre", "Foto", "Interpretacion", "FechaRegistro", "CirugiaId")
	VALUES ('2023-06-15', 'Radiografía Preoperatoria','foto de la radiografía', 'Sin hallazgos significativos', '2023-06-15 15:38:00', 1),
 ('2023-06-15', 'Radiografía Postoperatoria','foto de la radiografía', 'Buena colocación del implante', '2023-06-15 15:45:00', 2),
('2023-06-18', 'Radiografía Preoperatoria', 'foto de la radiografia', 'Sin hallazgos anormales', '2023-06-18 11:30', 3),
('2023-06-18', 'Radiografía Postoperatoria', 'foto de la radiografia', 'Buena respuesta al tratamiento', '2023-06-18 13:00', 3),
('2023-06-18', 'Radiografía Preoperatoria', 'foto de la radiografia', 'Caries en muela superior derecha', '2023-06-18 16:30', 4),
('2023-06-18', 'Radiografía Postoperatoria', 'foto de la radiografia', 'Éxito en la limpieza dental y endodoncia', '2023-06-18 18:45', 4),
('2023-06-19', 'Radiografía Preoperatoria', 'foto de la radiografia', 'Caries avanzada en muela inferior izquierda', '2023-06-19 12:45', 5),
('2023-06-19', 'Radiografía Postoperatoria', 'foto de la radiografia', 'Complicaciones leves identificadas', '2023-06-19 14:30', 5);

INSERT INTO public."InformeQuirurgico"("Nombre", "Detalle", "CirugiaId")
	VALUES ('Extracción de muela', 'Se extrajo la muela superior derecho debido al daño de la caries', 1),
('Extracción de muela', 'Se extrajo la muela superior izquierda y inferior derecho debido a la impactación', 2),
('Informe Cirugía de Extracción', 'Extracción de la muela superior derecha debido a caries avanzada.', 3),
('Informe Limpieza Dental', 'Limpieza dental realizada con éxito, eliminando el sarro acumulado.', 4),
('Informe Cirugía de Endodoncia', 'Realización de endodoncia en la muela inferior izquierda para tratar caries y aliviar dolor.', 5);

INSERT INTO public."EstadoPostquirurgico"("Fecha", "Nombre", "Detalle", "CirugiaId")
	VALUES ('2023-06-20','Estado postquirúrgico inicial', 'el paciente se encuentra estable', 1),
('2023-06-20','Seguimiento postoperatorio', 'El paciente muestra una buena evolución, sin signos de infección ni complicaciones.', 2),
('2023-06-16', 'Estado postoperatorio', 'El paciente presenta leve inflamación y dolor controlado. Se recomienda reposo y seguir indicaciones médicas.', 3),
('2023-06-16', 'Estado postoperatorio', 'La paciente experimenta molestias leves después de la limpieza dental. Se recomienda enjuague bucal suave.', 4),
('2023-06-17', 'Estado postoperatorio', 'Se observa una recuperación satisfactoria después de la endodoncia. El paciente debe seguir las indicaciones para cuidado bucal postoperatorio.', 5);

--gestion endodoncia
-- uno por paciente
INSERT INTO public."Endodoncia"("Fecha", "Docente", "Observaciones", "Operador", "MotivoConsulta", "PiezaDental", "ECPercucion", "ECCavidad", "ECCambiodeColor", "ECTejidosBlandos", "ECTermoreaccion", "ECElectroReaccion", "ERCavidad", "ERTratamientoPrevio", "ERPeriodonto", "ERLesionesPeriauriculares", "ERNumerodeConductos", "ERPrecipitacionesCalcicas", "STAnestesia", "STAAislamientoAbsoluto", "FechaRegistro", "PacienteId")
	VALUES ('2023-06-15', 'Dr. Rosales', 'Se observa sensibilidad en la pieza dental', 'Dr. Rosales', 'Dolor en la pieza dental', '2', 'Normal', 'Presenta caries en la cavidad pulpar', 'Sin cambio', 'Tejidos blandos normales', 'Normal', 'Sin aparente reacciones', 'Cavidad pulpar visible', 'Sin tratamiento previo', 'Periodonto en buen estado', 'Sin lesiones', '1', 'Sin precipitaciones', 'Anestesia local aplicada', 'Aislamiento absoluto con dique de goma', '2023-06-15 16:00', 1),
 ('2023-06-17', 'Dr. Rosales', 'Endodoncia realizada como parte del tratamiento integral', 'Dra. Gonzáles', 'Dolor persistente en la pieza 36', '36', 'Normal', 'Lesiones cariosas profundas', 'No aplica', 'Normal', 'Normal', 'Normal', 'Lesiones cariosas profundas', 'Sin tratamiento previo', 'Normal', 'No aplica', '3 conductos', 'No aplica', 'Local', 'Si', '2023-06-17 14:30', 1),
('2023-06-17', 'Dr. Gomez', 'Procedimiento de endodoncia en muela superior derecha.', 'Dr. Flores','Consulta por dolor en muela superior derecha', 'Muela Superior Derecha', 'Normal', 'Caries detectada en la cavidad pulpar','No hay cambio de color anormal', 'Tejidos blandos normales', 'No hay termoreacción anormal','No hay electroreacción anorma', 'Cavidad pulpar observada y tratada', 'Sin tratamiento previo','Normal', 'Sin lesiones periauriculares', 3, 0,'Anestesia local aplicada', 'Aislamiento absoluto utilizado','2023-06-17 10:30', 3),
('2023-06-16', 'Dr. Rosales', 'Procedimiento de endodoncia en muela inferior izquierda.', 'Dr. Rodríguez','Consulta por dolor en muela inferior izquierda', 'Muela Inferior Izquierda', 'Normal', 'Caries detectada en la cavidad pulpar', 'No hay cambio de color anormal', 'Tejidos blandos normales', 'No hay termoreacción anormal', 'No hay electroreacción anormal', 'Cavidad pulpar observada y tratada', 'Sin tratamiento previo', 'Normal', 'Sin lesiones periauriculares', 4, 0, 'Anestesia local aplicada', 'Aislamiento absoluto utilizado', '2023-06-16 11:45', 4),
('2023-06-17', 'Dr. Rosales', 'Procedimiento de endodoncia en muela superior derecha.', 'Dr. Tomas', 'Consulta por dolor en muela superior derecha', 'Muela Superior Derecha', 'Normal', 'Caries detectada en la cavidad pulpar', 'No hay cambio de color anormal', 'Tejidos blandos normales', 'No hay termoreacción anormal', 'No hay electroreacción anormal', 'Cavidad pulpar observada y tratada', 'Sin tratamiento previo', 'Normal', 'Sin lesiones periauriculares', 5, 0, 'Anestesia local aplicada.', 'Aislamiento absoluto utilizado.', '2023-06-17 10:30', 5);


---------------------------------------------------------------

INSERT INTO public."ManifestaciondelDolor"("Nombre")
	VALUES ('Dolor Pulsátil'),
 ('Dolor Agudo'),
 ('Dolor Pulsátil'),
 ('Dolor Pulsátil'),
 ('Dolor Pulsátil');

INSERT INTO public."ManifestacionEndodoncia"("Nombre", "EndodonciaId", "ManifestaciondelDolorId")
	VALUES ('Dolor pulsátil durante la noche', 1, 1),
('Dolor agudo al morder', 2, 2),
('Dolor durante la endodoncia', 1, 1),
('Dolor durante la endodoncia', 1, 1),
('Dolor durante la endodoncia', 1, 1);

INSERT INTO public."Conductometria"("Conducto", "LongRx", "LongTrabajo", "IInicial", "Referencia", "FechaRegistro", "EndodonciaId")
	VALUES ('Conducto Principal', '21 mm', '22 mm', '8 mA', 'Apex del conducto', '2023-06-15', 1),
('Conducto 2', '18 mm', '20 mm', '0.7 mA', 'Referencia 2', '2023-06-15', 1),
('Conducto Principal', '21 mm', '22 mm', '8 mA', 'Apex del conducto', '2023-06-15', 1),
('Conducto Principal', '21 mm', '22 mm', '8 mA', 'Apex del conducto', '2023-06-15', 1),
('Conducto Principal', '21 mm', '22 mm', '8 mA', 'Apex del conducto', '2023-06-15', 1);

INSERT INTO public."PreparacionQuimicoMecanica"("Conducto", "Tecnica", "IFinal", "UltimaLongitudTrabajo", "Referencia", "FechaRegistro", "EndodonciaId")
	VALUES ('Conducto principal', 'Técnica de Crown-Down', '7 mA', '21 mm', 'Apex del conducto', '2023-06-15', 1),
 ('Conducto 2', 'Técnica B', '0.9 mA', '20 mm', 'Referencia 2', '2023-06-15', 1),
 ('Conducto principal', 'Técnica de Crown-Down', '7 mA', '21 mm', 'Apex del conducto', '2023-06-15', 1),
 ('Conducto principal', 'Técnica de Crown-Down', '7 mA', '21 mm', 'Apex del conducto', '2023-06-15', 1),
 ('Conducto principal', 'Técnica de Crown-Down', '7 mA', '21 mm', 'Apex del conducto', '2023-06-15', 1);

INSERT INTO public."ObturaciondeConductos"("Conducto", "Tecnica", "UltimaLongitudTrabajo", "ConoMaestro", "Referencia", "FechaRegistro", "EndodonciaId")
	VALUES ('Conducto principal', 'Obturación Lateral', '21 mm', 'Cono de Gutapercha #30', 'Apex del conducto', '2023-06-15', 1),
('Conducto 2', 'Técnica Y', '18 mm', 'Cono B', 'Referencia 2', '2023-06-16', 1),
('Conducto principal', 'Obturación Lateral', '21 mm', 'Cono de Gutapercha #30', 'Apex del conducto', '2023-06-15', 1),
('Conducto principal', 'Obturación Lateral', '21 mm', 'Cono de Gutapercha #30', 'Apex del conducto', '2023-06-15', 1),
('Conducto principal', 'Obturación Lateral', '21 mm', 'Cono de Gutapercha #30', 'Apex del conducto', '2023-06-15', 1);

INSERT INTO public."RadiografiaEndodoncia"("Fecha", "Foto", "Interpretacion", "FechaRegistro", "EndodonciaId")
	VALUES ('2023-06-15', 'foto de la radiografia', 'Obturación satisfactoria del conducto principal', '2023-06-15', 1),
('2023-06-16', 'foto de la radiografia', 'Interpretación B', '2023-06-15', 1),
('2023-06-15', 'foto de la radiografia', 'Obturación satisfactoria del conducto principal', '2023-06-15', 1),
('2023-06-15', 'foto de la radiografia', 'Obturación satisfactoria del conducto principal', '2023-06-15', 1),
('2023-06-15', 'foto de la radiografia', 'Obturación satisfactoria del conducto principal', '2023-06-15', 1);
