const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const AuditoriaController = {
  async createAuditoria(req, res) {
    try {
      const {
        Nombre,
        Semestre,
        Malla
      } = req.body;
      const Auditoria = await prisma.Auditoria.create(
        {
          data: {
            Nombre,
            Semestre,
            Malla
          }
        }
      );
      res.json(Auditoria);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'Auditoria creada correctamente',
      //     data: Auditoria
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Auditoria',
          error
        }
      );
    }
  },

  async getAllAuditorias(req, res) {
    try {
      const Auditorias = await prisma.Auditoria.findMany();
      if (Auditorias.length > 0) {
        res.json(Auditorias);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Auditorias',
        //     data: Auditorias
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Auditorias registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Auditorias',
          error
        }
      );
    }
  },

  async getAuditoriaById(req, res) {
    try {
      const { id } = req.params;
      const Auditoria = await prisma.Auditoria.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (Auditoria !== null) {
        res.json(Auditoria);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Auditoria encontrada',
        //     data: Auditoria
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Auditoria con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Auditoria',
          error
        }
      );
    }
  },

  async updateAuditoria(req, res) {
    try {
      const { id } = req.params;
      const {
        Nombre,
        Semestre,
        Malla
      } = req.body;
      const Auditoria = await prisma.Auditoria.update(
        {
          where: {
            id: parseInt(id)
          },
          data: {
            Nombre,
            Semestre,
            Malla
          }
        }
      );
      res.json(Auditoria);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'Auditoria actualizada correctamente',
      //     data: Auditoria
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Auditoria',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Auditoria
  // async deleteAuditoria(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.Auditoria.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'Auditoria eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Auditoria',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = AuditoriaController;
