const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const CasoDienteController = {
  async createCasoDiente(req, res) {
    try {
      const { Nombre, Foto, SubCasoClinicoId, DienteId } = req.body;
      const casodiente = await prisma.casoDiente.create(
        {
          data: { Nombre, Foto, SubCasoClinicoId, DienteId }
        }
      );
      res.json(casodiente);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'CasoDiente creada correctamente',
      //     data: casodiente
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la CasoDiente',
          error
        }
      );
    }
  },

  async getAllCasoDientes(req, res) {
    try {
      const casosdiente = await prisma.casoDiente.findMany();
      // res.json(casosclinicos)
      if (casosdiente.length > 0) {
        res.json(casosdiente);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de CasoDientes',
        //     data: casosdiente
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay CasoDientes registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de CasoDientes',
          error
        }
      );
    }
  },

  async getCasoDienteBySubCasoClinico(req, res) {
    try {
      const { codigo } = req.params;
      const casosdiente = await prisma.casoDiente.findMany(
        {
          where: {
            SubCasoClinicoId: parseInt(codigo)
          }
        }
      );
      if (casosdiente.length > 0) {
        res.json(casosdiente);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de CasoDientes',
        //     data: casosdiente
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay CasoDientes registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de CasoDientes',
          error
        }
      );
    }
  },

  async getCasoDienteByDiente(req, res) {
    try {
      const { codigo } = req.params;
      const casosdiente = await prisma.casoDiente.findMany(
        {
          where: {
            DienteId: parseInt(codigo)
          }
        }
      );
      if (casosdiente.length > 0) {
        res.json(casosdiente);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de CasoDientes',
        //     data: casosdiente
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay CasoDientes registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de CasoDientes',
          error
        }
      );
    }
  },

  async getCasoDienteById(req, res) {
    try {
      const { id } = req.params;
      const casodiente = await prisma.casoDiente.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (casodiente !== null) {
        res.json(casodiente);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'CasoDiente encontrada',
        //     data: casodiente
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la CasoDiente con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la CasoDiente',
          error
        }
      );
    }
  },

  async updateCasoDiente(req, res) {
    try {
      const { id } = req.params;
      const { Nombre, Foto, SubCasoClinicoId, DienteId } = req.body;
      const casodiente = await prisma.casoDiente.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Nombre, Foto, SubCasoClinicoId, DienteId }
        }
      );
      res.json(casodiente);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'CasoDiente actualizada correctamente',
      //     data: casodiente
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la CasoDiente',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una CasoDiente
  // async deleteCasoDiente(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.casoDiente.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'CasoDiente eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la CasoDiente',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = CasoDienteController;
