const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const CitaController = {
  async createCita(req, res) {
    try {
      const { Fecha, Hora, Odontologo, Empresa, Sede, 
        Lugar, Extras, PacienteId, UsuarioId } = req.body;
      const cita = await prisma.cita.create(
        {
          data: { Fecha, Hora, Odontologo, Empresa, Sede, 
            Lugar, Extras, PacienteId, UsuarioId }
        }
      );
      // res.json(cita);
      res.json(
        {
          status: 'success',
          msj: 'Cita creada correctamente',
          data: cita
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Cita',
          error
        }
      );
    }
  },

  async getAllCitas(req, res) {
    try {
      const citas = await prisma.cita.findMany(
        {
          include: {
            usuario: true,
            paciente: true
          }
        }
      );
      if (citas.length > 0) {
        // res.json(citas);
        res.json(
          {
            status: 'success',
            msj: 'Lista de Citas',
            data: citas
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Citas registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Citas',
          error
        }
      );
    }
  },

  async getCitaBySede(req, res) {
    try {
      const { lasede } = req.params;
      const citas = await prisma.cita.findMany(
        {
          where: {  
            Sede: lasede
          },
          include: {
            usuario: true,
            paciente: true
          }
        }
      );
      if (citas.length > 0) {
        // res.json(Citas);
        res.json(
          {
            status: 'success',
            msj: 'Lista de Citas',
            data: citas
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Citas registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Citas',
          error
        }
      );
    }
  },

  async getCitaByUsuario(req, res) {
    try {
      const { codigo } = req.params;
      const citas = await prisma.cita.findMany(
        {
          where: {
            UsuarioId: parseInt(codigo)
          },
          include: {
            usuario: true,
            paciente: true
          }
        }
      );
      if (citas.length > 0) {
        // res.json(Citas);
        res.json(
          {
            status: 'success',
            msj: 'Lista de Citas',
            data: citas
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Citas registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Citas',
          error
        }
      );
    }
  },

  async getCitaByPaciente(req, res) {
    try {
      const { codigo } = req.params;
      const citas = await prisma.cita.findMany(
        {
          where: {
            PacienteId: parseInt(codigo)
          },
          include: {
            usuario: true,
            paciente: true
          }
        }
      );
      if (citas.length > 0) {
        // res.json(Citas);
        res.json(
          {
            status: 'success',
            msj: 'Lista de Citas',
            data: citas
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Citas registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Citas',
          error
        }
      );
    }
  },

  async getCitaByFechaandSede(req, res) {
    try {
      const { lafecha, empresa, sede } = req.params;
      const citas = await prisma.cita.findMany(
        {
          where: {
            Fecha: lafecha,
            Empresa: empresa,
            Sede: sede
          },
          include: {
            usuario: true,
            paciente: true
          }
        }
      );
      if (citas.length > 0) {
        // res.json(Citas);
        res.json(
          {
            status: 'success',
            msj: 'Lista de Citas',
            data: citas
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Citas registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Citas',
          error
        }
      );
    }
  },

  async getCitaById(req, res) {
    try {
      const { id } = req.params;
      const cita = await prisma.cita.findUnique(
        {
          where: {
            id: parseInt(id)
          },
          include: {
            usuario: true,
            paciente: true
          }
        }
      );
      if (cita !== null) {
        // res.json(Cita);
        res.json(
          {
            status: 'success',
            msj: 'Cita encontrada',
            data: cita
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Cita con el id indicado'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Cita',
          error
        }
      );
    }
  },

  async updateCita(req, res) {
    try {
      const { id } = req.params;
      const { Fecha, Hora, Odontologo, Empresa, Sede, 
        Lugar, Extras, PacienteId, UsuarioId } = req.body;
      const cita = await prisma.cita.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Fecha, Hora, Odontologo, Empresa, Sede, 
            Lugar, Extras, PacienteId, UsuarioId }
        }
      );
      // res.json(Cita);
      res.json(
        {
          status: 'success',
          msj: 'Cita actualizada correctamente',
          data: cita
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Cita',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Cita
  // async deleteCita(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.cita.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'Cita eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Cita',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = CitaController;
