const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const CursoController = {
  async createCurso(req, res) {
    try {
      const {
        Nombre,
        Semestre,
        Malla
      } = req.body;
      const curso = await prisma.curso.create(
        {
          data: {
            Nombre,
            Semestre,
            Malla
          }
        }
      );
      res.json(curso);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'Curso creada correctamente',
      //     data: curso
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Curso',
          error
        }
      );
    }
  },

  async getAllCursos(req, res) {
    try {
      const cursos = await prisma.curso.findMany();
      if (cursos.length > 0) {
        res.json(cursos);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Cursos',
        //     data: cursos
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Cursos registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Cursos',
          error
        }
      );
    }
  },

  async getCursoById(req, res) {
    try {
      const { id } = req.params;
      const curso = await prisma.Curso.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (curso !== null) {
        res.json(curso);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Curso encontrada',
        //     data: curso
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Curso con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Curso',
          error
        }
      );
    }
  },

  async updateCurso(req, res) {
    try {
      const { id } = req.params;
      const {
        Nombre,
        Semestre,
        Malla
      } = req.body;
      const curso = await prisma.curso.update(
        {
          where: {
            id: parseInt(id)
          },
          data: {
            Nombre,
            Semestre,
            Malla
          }
        }
      );
      res.json(curso);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'Curso actualizada correctamente',
      //     data: curso
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Curso',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Curso
  // async deleteCurso(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.curso.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'Curso eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Curso',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = CursoController;
