const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const EpicrisisController = {
  async createEpicrisis(req, res) {
    try {
      const { Contenido, FechaRegistro, PacienteId } = req.body;
      const epicrisis = await prisma.epicrisis.create(
        {
          data: { Contenido, FechaRegistro, PacienteId }
        }
      );
      // res.json(epicrisis);
      res.json(
        {
          status: 'success',
          msj: 'Epicrisis creada correctamente',
          data: epicrisis
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Epicrisis',
          error
        }
      );
    }
  },

  async getAllEpicrisiss(req, res) {
    try {
      const epicrisis = await prisma.epicrisis.findMany();
      if (epicrisis.length > 0) {
        // res.json(epicrisis);
        res.json(
          {
            status: 'success',
            msj: 'Lista de Epicrisiss',
            data: epicrisis
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Epicrisiss registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Epicrisiss',
          error
        }
      );
    }
  },

  async getEpicrisisByPaciente(req, res) {
    try {
      const { codigo } = req.params;
      const epicrisis = await prisma.epicrisis.findMany(
        {
          where: {
            PacienteId: parseInt(codigo)
          }
        }
      );
      if (epicrisis.length > 0) {
        // res.json(epicrisis);
        res.json(
          {
            status: 'success',
            msj: 'Lista de Epicrisiss',
            data: epicrisis
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Epicrisiss registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Epicrisiss',
          error
        }
      );
    }
  },

  async getEpicrisisById(req, res) {
    try {
      const { id } = req.params;
      const epicrisis = await prisma.epicrisis.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (epicrisis !== null) {
        // res.json(epicrisis);
        res.json(
          {
            status: 'success',
            msj: 'Epicrisis encontrada',
            data: epicrisis
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Epicrisis con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Epicrisis',
          error
        }
      );
    }
  },

  async updateEpicrisis(req, res) {
    try {
      const { id } = req.params;
      const { Contenido, FechaRegistro, PacienteId } = req.body;
      const epicrisis = await prisma.epicrisis.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Contenido, FechaRegistro, PacienteId }
        }
      );
      // res.json(epicrisis);
      res.json(
        {
          status: 'success',
          msj: 'Epicrisis actualizada correctamente',
          data: epicrisis
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Epicrisis',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Epicrisis
  // async deleteEpicrisis(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.epicrisis.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'Epicrisis eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Epicrisis',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = EpicrisisController;
