const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const EstadoPostquirurgicoController = {
  async createEstadoPostquirurgico(req, res) {
    try {
      const { Fecha, Nombre, Detalle, CirugiaId } = req.body;
      const estadopostquirurgico = await prisma.estadoPostquirurgico.create(
        {
          data: { Fecha, Nombre, Detalle, CirugiaId }
        }
      );
      // res.json(estadopostquirurgico);
      res.json(
        {
          status: 'success',
          msj: 'EstadoPostquirurgico creada correctamente',
          data: estadopostquirurgico
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la EstadoPostquirurgico',
          error
        }
      );
    }
  },

  async getAllEstadoPostquirurgicos(req, res) {
    try {
      const estadospostquirurgico = await prisma.estadoPostquirurgico.findMany();
      if (estadospostquirurgico.length > 0) {
        // res.json(estadospostquirurgico);
        res.json(
          {
            status: 'success',
            msj: 'Lista de EstadoPostquirurgicos',
            data: estadospostquirurgico
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay EstadoPostquirurgicos registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de EstadoPostquirurgicos',
          error
        }
      );
    }
  },

  async getEstadoPostquirurgicoByCirugia(req, res) {
    try {
      const { codigo } = req.params;
      const estadospostquirurgico = await prisma.estadoPostquirurgico.findMany(
        {
          where: {
            CirugiaId: parseInt(codigo)
          }
        }
      );
      if (estadospostquirurgico.length > 0) {
        // res.json(estadospostquirurgico);
        res.json(
          {
            status: 'success',
            msj: 'Lista de EstadoPostquirurgicos',
            data: estadospostquirurgico
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay EstadoPostquirurgicos registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de EstadoPostquirurgicos',
          error
        }
      );
    }
  },

  async getEstadoPostquirurgicoById(req, res) {
    try {
      const { id } = req.params;
      const estadopostquirurgico = await prisma.estadoPostquirurgico.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (estadopostquirurgico !== null) {
        // res.json(estadopostquirurgico);
        res.json(
          {
            status: 'success',
            msj: 'EstadoPostquirurgico encontrada',
            data: estadopostquirurgico
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la EstadoPostquirurgico con el id indicado'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la EstadoPostquirurgico',
          error
        }
      );
    }
  },

  async updateEstadoPostquirurgico(req, res) {
    try {
      const { id } = req.params;
      const { Fecha, Nombre, Detalle, CirugiaId } = req.body;
      const estadopostquirurgico = await prisma.estadoPostquirurgico.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Fecha, Nombre, Detalle, CirugiaId }
        }
      );
      // res.json(estadopostquirurgico);
      res.json(
        {
          status: 'success',
          msj: 'EstadoPostquirurgico actualizada correctamente',
          data: estadopostquirurgico
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la EstadoPostquirurgico',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una EstadoPostquirurgico
  // async deleteEstadoPostquirurgico(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.estadoPostquirurgico.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'EstadoPostquirurgico eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la EstadoPostquirurgico',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = EstadoPostquirurgicoController;
