const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const ExamenGeneralController = {
  async createExamenGeneral(req, res) {
    try {
      const { Peso, Talla, IndiceMasaCorporal, Piel, AnexoCabello, AnexoUnias, 
        PresionArterial, FrecuenciaRespiratoria, Pulso, Temperatura, PacienteId } = req.body;
      const examengeneral = await prisma.examenGeneral.create(
        {
          data: { Peso, Talla, IndiceMasaCorporal, Piel, AnexoCabello, AnexoUnias, 
            PresionArterial, FrecuenciaRespiratoria, Pulso, Temperatura, PacienteId: parseInt(PacienteId) }
        }
      );
      // res.json(examengeneral);
      res.json(
        {
          status: 'success',
          msj: 'ExamenGeneral creada correctamente',
          data: examengeneral
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la ExamenGeneral',
          error
        }
      );
    }
  },

  async getAllExamenGenerals(req, res) {
    try {
      const examenesgenerales = await prisma.examenGeneral.findMany();
      if (examenesgenerales.length > 0) {
        // res.json(examenesgenerales);
        res.json(
          {
            status: 'success',
            msj: 'Lista de ExamenGenerals',
            data: examenesgenerales
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay ExamenGenerals registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de ExamenGenerals',
          error
        }
      );
    }
  },

  async getExamenGeneralByPaciente(req, res) {
    try {
      const { codigo } = req.params;
      const examengeneral = await prisma.examenGeneral.findFirst(
        {
          where: {
            PacienteId: parseInt(codigo)
          }
        }
      );
      if (examengeneral !== null) {
        // res.json(examengeneral);
        res.json(
          {
            status: 'success',
            msj: 'Examen General del Paciente',
            data: examengeneral
          }
        );
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Examenes Generales del Paciennte',
        //     data: examenesgeneral
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay ExamenGenerals registradas'
          }
        );
      }
      // if (examenesgenerales.length > 0) {
      //   res.json(examenesgenerales);
      //   // res.json(
      //   //   {
      //   //     status: 'success',
      //   //     msj: 'Lista de ExamenGenerals',
      //   //     data: examenesgenerales
      //   //   }
      //   // );
      // } else {
      //   res.json(
      //     {
      //       status: 'warning',
      //       mesj: 'No hay ExamenGenerals registradas'
      //     }
      //   );
      // }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de ExamenGenerals',
          error
        }
      );
    }
  },

  async getExamenGeneralById(req, res) {
    try {
      const { id } = req.params;
      const examengeneral = await prisma.examenGeneral.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (examengeneral !== null) {
        // res.json(examengeneral);
        res.json(
          {
            status: 'success',
            msj: 'ExamenGeneral encontrada',
            data: examengeneral
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la ExamenGeneral con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la ExamenGeneral',
          error
        }
      );
    }
  },

  async updateExamenGeneral(req, res) {
    try {
      const { id } = req.params;
      const { Peso, Talla, IndiceMasaCorporal, Piel, AnexoCabello, AnexoUnias, 
        PresionArterial, FrecuenciaRespiratoria, Pulso, Temperatura, PacienteId } = req.body;
      const examengeneral = await prisma.examenGeneral.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Peso, Talla, IndiceMasaCorporal, Piel, AnexoCabello, AnexoUnias, 
            PresionArterial, FrecuenciaRespiratoria, Pulso, Temperatura, PacienteId }
        }
      );
      // res.json(examengeneral);
      res.json(
        {
          status: 'success',
          msj: 'ExamenGeneral actualizada correctamente',
          data: examengeneral
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la ExamenGeneral',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una ExamenGeneral
  // async deleteExamenGeneral(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.examenGeneral.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'ExamenGeneral eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la ExamenGeneral',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = ExamenGeneralController;
