const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const InformeQuirurgicoController = {
  async createInformeQuirurgico(req, res) {
    try {
      const { Nombre, Detalle, CirugiaId } = req.body;
      const informequirurgico = await prisma.informeQuirurgico.create(
        {
          data: { Nombre, Detalle, CirugiaId }
        }
      );
      // res.json(informequirurgico);
      res.json(
        {
          status: 'success',
          msj: 'InformeQuirurgico creada correctamente',
          data: informequirurgico
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la InformeQuirurgico',
          error
        }
      );
    }
  },

  async getAllInformeQuirurgicos(req, res) {
    try {
      const informeesquirurgicos = await prisma.informeQuirurgico.findMany();
      if (informeesquirurgicos.length > 0) {
        // res.json(informeesquirurgicos);
        res.json(
          {
            status: 'success',
            msj: 'Lista de InformeQuirurgicos',
            data: informeesquirurgicos
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay InformeQuirurgicos registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de InformeQuirurgicos',
          error
        }
      );
    }
  },

  async getInformeQuirurgicoByCirugia(req, res) {
    try {
      const { codigo } = req.params;
      const informeesquirurgicos = await prisma.informeQuirurgico.findMany(
        {
          where: {
            CirugiaId: parseInt(codigo)
          }
        }
      );
      if (informeesquirurgicos.length > 0) {
        // res.json(informeesquirurgicos);
        res.json(
          {
            status: 'success',
            msj: 'Lista de InformeQuirurgicos',
            data: informeesquirurgicos
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay InformeQuirurgicos registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de InformeQuirurgicos',
          error
        }
      );
    }
  },

  async getInformeQuirurgicoById(req, res) {
    try {
      const { id } = req.params;
      const informequirurgico = await prisma.informeQuirurgico.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (informequirurgico !== null) {
        // res.json(informequirurgico);
        res.json(
          {
            status: 'success',
            msj: 'InformeQuirurgico encontrada',
            data: informequirurgico
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la InformeQuirurgico con el id indicado'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la InformeQuirurgico',
          error
        }
      );
    }
  },

  async updateInformeQuirurgico(req, res) {
    try {
      const { id } = req.params;
      const { Nombre, Detalle, CirugiaId } = req.body;
      const informequirurgico = await prisma.informeQuirurgico.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Nombre, Detalle, CirugiaId }
        }
      );
      // res.json(informequirurgico);
      res.json(
        {
          status: 'success',
          msj: 'InformeQuirurgico actualizada correctamente',
          data: informequirurgico
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la InformeQuirurgico',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una InformeQuirurgico
  // async deleteInformeQuirurgico(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.informeQuirurgico.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'InformeQuirurgico eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la InformeQuirurgico',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = InformeQuirurgicoController;
