const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const OperatoriaController = {
  async createOperatoria(req, res) {
    try {
      const { Docente, MotivoConsulta, DiagnosticoDefinitivo, PacienteId } = req.body;
      const operatoria = await prisma.operatoria.create(
        {
          data: { Docente, MotivoConsulta, DiagnosticoDefinitivo, PacienteId }
        }
      );
      // res.json(operatoria);
      res.json(
        {
          status: 'success',
          msj: 'Operatoria creada correctamente',
          data: operatoria
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Operatoria',
          error
        }
      );
    }
  },

  async getAllOperatorias(req, res) {
    try {
      const operatorias = await prisma.operatoria.findMany();
      if (operatorias.length > 0) {
        // res.json(operatorias);
        res.json(
          {
            status: 'success',
            msj: 'Lista de Operatorias',
            data: operatorias
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Operatorias registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Operatorias',
          error
        }
      );
    }
  },

  async getOperatoriaByPaciente(req, res) {
    try {
      const { codigo } = req.params;
      const operatorias = await prisma.operatoria.findMany(
        {
          where: {
            PacienteId: parseInt(codigo)
          }
        }
      );
      if (operatorias.length > 0) {
        // res.json(operatorias);
        res.json(
          {
            status: 'success',
            msj: 'Lista de Operatorias',
            data: operatorias
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Operatorias registradas'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Operatorias',
          error
        }
      );
    }
  },

  async getOperatoriaById(req, res) {
    try {
      const { id } = req.params;
      const operatoria = await prisma.operatoria.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (operatoria !== null) {
        // res.json(operatoria);
        res.json(
          {
            status: 'success',
            msj: 'Operatoria encontrada',
            data: operatoria
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Operatoria con el id indicado'
          }
        );
      }
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Operatoria',
          error
        }
      );
    }
  },

  async updateOperatoria(req, res) {
    try {
      const { id } = req.params;
      const { Docente, MotivoConsulta, DiagnosticoDefinitivo, PacienteId } = req.body;
      const operatoria = await prisma.operatoria.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Docente, MotivoConsulta, DiagnosticoDefinitivo, PacienteId }
        }
      );
      // res.json(operatoria);
      res.json(
        {
          status: 'success',
          msj: 'Operatoria actualizada correctamente',
          data: operatoria
        }
      );
    } catch (error) {
      console.log(error);
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Operatoria',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Operatoria
  // async deleteOperatoria(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.operatoria.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'Operatoria eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Operatoria',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = OperatoriaController;
