const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const PlanTratamientoController = {
  async createPlanTratamiento(req, res) {
    try {
      const { Nombre, Detalle, CirugiaId } = req.body;
      const plantratamiento = await prisma.planTratamiento.create(
        {
          data: { Nombre, Detalle, CirugiaId }
        }
      );
      // res.json(plantratamiento);
      res.json(
        {
          status: 'success',
          msj: 'PlanTratamiento creada correctamente',
          data: plantratamiento
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la PlanTratamiento',
          error
        }
      );
    }
  },

  async getAllPlanTratamientos(req, res) {
    try {
      const planestratamiento = await prisma.planTratamiento.findMany();
      if (planestratamiento.length > 0) {
        // res.json(planestratamiento);
        res.json(
          {
            status: 'success',
            msj: 'Lista de PlanTratamientos',
            data: planestratamiento
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay PlanTratamientos registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de PlanTratamientos',
          error
        }
      );
    }
  },

  async getPlanTratamientoByCirugia(req, res) {
    try {
      const { codigo } = req.params;
      const planestratamiento = await prisma.planTratamiento.findMany(
        {
          where: {
            CirugiaId: parseInt(codigo)
          }
        }
      );
      if (planestratamiento.length > 0) {
        // res.json(planestratamiento);
        res.json(
          {
            status: 'success',
            msj: 'Lista de PlanTratamientos',
            data: planestratamiento
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay PlanTratamientos registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de PlanTratamientos',
          error
        }
      );
    }
  },

  async getPlanTratamientoById(req, res) {
    try {
      const { id } = req.params;
      const plantratamiento = await prisma.planTratamiento.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (plantratamiento !== null) {
        // res.json(plantratamiento);
        res.json(
          {
            status: 'success',
            msj: 'PlanTratamiento encontrada',
            data: plantratamiento
          }
        );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la PlanTratamiento con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la PlanTratamiento',
          error
        }
      );
    }
  },

  async updatePlanTratamiento(req, res) {
    try {
      const { id } = req.params;
      const { Conducto, LongRx, LongTrabajo, IInicial, Referencia, 
        FechaRegistro, CirugiaId } = req.body;
      const plantratamiento = await prisma.planTratamiento.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Conducto, LongRx, LongTrabajo, 
            IInicial, Referencia, 
            FechaRegistro, CirugiaId }
        }
      );
      // res.json(plantratamiento);
      res.json(
        {
          status: 'success',
          msj: 'PlanTratamiento actualizada correctamente',
          data: plantratamiento
        }
      );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la PlanTratamiento',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una PlanTratamiento
  // async deletePlanTratamiento(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.planTratamiento.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'PlanTratamiento eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la PlanTratamiento',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = PlanTratamientoController;
