const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const SedeController = {
  async createSede(req, res) {
    try {
      const { Nombre, Direccion, Celular, Correo, TipoSede, EmpresaId } = req.body;
      const sede = await prisma.sede.create(
        {
          data: { Nombre, Direccion, Celular, Correo, TipoSede, EmpresaId }
        }
      );
      res.json(sede);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'Sede creada correctamente',
      //     data: sede
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la Sede',
          error
        }
      );
    }
  },

  async getAllSedes(req, res) {
    try {
      const sedes = await prisma.sede.findMany();
      if (sedes.length > 0) {
        res.json(sedes);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Sedes',
        //     data: sedes
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Sedes registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Sedes',
          error
        }
      );
    }
  },

  async empresaSede(req, res) {
    try {
      const { codigo } = req.params;
      const sedes = await prisma.sede.findMany(
        {
          where: {
            EmpresaId: parseInt(codigo)
          }
        }
      );
      if (sedes.length > 0) {
        res.json(sedes);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de Sedes de la Empresa indicada',
        //     data: sedes
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay Sedes registradas de la Empresa indicada'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de Sedes',
          error
        }
      );
    }
  },

  async getSedeById(req, res) {
    try {
      const { id } = req.params;
      const sede = await prisma.sede.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (sede !== null) {
        res.json(sede);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Sede encontrada',
        //     data: sede
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la Sede con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la Sede',
          error
        }
      );
    }
  },

  async updateSede(req, res) {
    try {
      const { id } = req.params;
      const { Nombre, Direccion, Celular, Correo, TipoSede, EmpresaId } = req.body;
      const sede = await prisma.sede.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Nombre, Direccion, Celular, Correo, TipoSede, EmpresaId }
        }
      );
      res.json(sede);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'Sede actualizada correctamente',
      //     data: sede
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la Sede',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una Sede
  // async deleteSede(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.sede.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'Sede eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la Sede',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = SedeController;
