const { PrismaClient } = require('@prisma/client');

const prisma = new PrismaClient();

const SubCasoClinicoController = {
  async createSubCasoClinico(req, res) {
    try {
      const { Nombre, CasoClinicoId } = req.body;
      const subcasoclinico = await prisma.subCasoClinico.create(
        {
          data: { Nombre, CasoClinicoId }
        }
      );
      res.json(subcasoclinico);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'SubCasoClinico creada correctamente',
      //     data: subcasoclinico
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al crear la SubCasoClinico',
          error
        }
      );
    }
  },

  async getAllSubCasoClinicos(req, res) {
    try {
      const subcasosclinicos = await prisma.subCasoClinico.findMany();
      if (subcasosclinicos.length > 0) {
        res.json(subcasosclinicos);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de SubCasoClinicos',
        //     data: subcasosclinicos
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay SubCasoClinicos registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de SubCasoClinicos',
          error
        }
      );
    }
  },

  async getSubCasoClinicoByCasoClinico(req, res) {
    try {
      const { codigo } = req.params;
      const subcasosclinicos = await prisma.subCasoClinico.findMany(
        {
          where: {
            CasoClinicoId: parseInt(codigo)
          }
        }
      );
      if (subcasosclinicos.length > 0) {
        res.json(subcasosclinicos);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'Lista de SubCasoClinicos',
        //     data: subcasosclinicos
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No hay SubCasoClinicos registradas'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la lista de SubCasoClinicos',
          error
        }
      );
    }
  },

  async getSubCasoClinicoById(req, res) {
    try {
      const { id } = req.params;
      const subcasoclinico = await prisma.subCasoClinico.findUnique(
        {
          where: {
            id: parseInt(id)
          }
        }
      );
      if (subcasoclinico !== null) {
        res.json(subcasoclinico);
        // res.json(
        //   {
        //     status: 'success',
        //     msj: 'SubCasoClinico encontrada',
        //     data: subcasoclinico
        //   }
        // );
      } else {
        res.json(
          {
            status: 'warning',
            mesj: 'No existe la SubCasoClinico con el id indicado'
          }
        );
      }
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al obtener la SubCasoClinico',
          error
        }
      );
    }
  },

  async updateSubCasoClinico(req, res) {
    try {
      const { id } = req.params;
      const { Nombre, CasoClinicoId } = req.body;
      const subcasoclinico = await prisma.subCasoClinico.update(
        {
          where: {
            id: parseInt(id)
          },
          data: { Nombre, CasoClinicoId }
        }
      );
      res.json(subcasoclinico);
      // res.json(
      //   {
      //     status: 'success',
      //     msj: 'SubCasoClinico actualizada correctamente',
      //     data: subcasoclinico
      //   }
      // );
    } catch (error) {
      res.status(500).json(
        {
          status: 'danger',
          msj: 'Error al actualizar la SubCasoClinico',
          error
        }
      );
    }
  },

// se oviara la opcion de poder eliminar una SubCasoClinico
  // async deleteSubCasoClinico(req, res) {
  //   try {
  //     const { id } = req.params;
  //     await prisma.subCasoClinico.delete(
  //       {
  //         where: {
  //           id: parseInt(id)
  //         }
  //       }
  //     );
  //     res.json(
  //       {
  //         status: 'success',
  //         mesj: 'SubCasoClinico eliminada'
  //       }
  //     );
  //   } catch (error) {
  //     res.status(500).json(
  //       {
  //         status: 'danger',
  //         msj: 'Error al eliminar la SubCasoClinico',
  //         error
  //       }
  //     );
  //   }
  // }
}

module.exports = SubCasoClinicoController;
