const express = require('express');
const router = express.Router();
const AnamnesisController = require('../controllers/anamnesis.controller');

// GET all Anamnesiss
router.get('/', AnamnesisController.getAllAnamnesiss);

// GET Anamnesis by id
router.get('/:id', AnamnesisController.getAnamnesisById);

// POST a new Anamnesis
router.post('/create', AnamnesisController.createAnamnesis);

// PUT update an existing Anamnesis
router.put('/update/:id', AnamnesisController.updateAnamnesis);

// DELETE an existing Anamnesis
// muy probable no considerar esta opción
// router.delete('/:id', AnamnesisController.deleteAnamnesis);

// para los filtros de Anamnesis
router.get('/search/paciente/:codigo', AnamnesisController.getAnamnesisByPaciente);

module.exports = router;
