const express = require('express');
const router = express.Router();
const CasoClinicoController = require('../controllers/casoclinico.controller');

// GET all CasoClinicos
router.get('/', CasoClinicoController.getAllCasoClinicos);

// GET CasoClinico by id
router.get('/:id', CasoClinicoController.getCasoClinicoById);

// POST a new CasoClinico
router.post('/create', CasoClinicoController.createCasoClinico);

// PUT update an existing CasoClinico
router.put('/update/:id', CasoClinicoController.updateCasoClinico);

// DELETE an existing CasoClinico
// muy probable no considerar esta opción
// router.delete('/:id', CasoClinicoController.deleteCasoClinico);

module.exports = router;
