const express = require('express');
const router = express.Router();
const EpicrisisController = require('../controllers/epicrisis.controller');

// GET all Epicrisiss
router.get('/', EpicrisisController.getAllEpicrisiss);

// GET Epicrisis by id
router.get('/:id', EpicrisisController.getEpicrisisById);

// POST a new Epicrisis
router.post('/create', EpicrisisController.createEpicrisis);

// PUT update an existing Epicrisis
router.put('/update/:id', EpicrisisController.updateEpicrisis);

// DELETE an existing Epicrisis
// muy probable no considerar esta opción
// router.delete('/:id', EpicrisisController.deleteEpicrisis);

// para los filtros de Epicrisis
router.get('/search/paciente/:codigo', EpicrisisController.getEpicrisisByPaciente);

module.exports = router;
