const express = require('express');
const router = express.Router();
const EstadoPostquirurgicoController = require('../controllers/estadopostqurirgico.controller');

// GET all EstadoPostquirurgicos
router.get('/', EstadoPostquirurgicoController.getAllEstadoPostquirurgicos);

// GET EstadoPostquirurgico by id
router.get('/:id', EstadoPostquirurgicoController.getEstadoPostquirurgicoById);

// POST a new EstadoPostquirurgico
router.post('/create', EstadoPostquirurgicoController.createEstadoPostquirurgico);

// PUT update an existing EstadoPostquirurgico
router.put('/update/:id', EstadoPostquirurgicoController.updateEstadoPostquirurgico);

// DELETE an existing EstadoPostquirurgico
// muy probable no considerar esta opción
// router.delete('/:id', EstadoPostquirurgicoController.deleteEstadoPostquirurgico);

// para los filtros de EstadoPostquirurgico
router.get('/search/cirugia/:codigo', EstadoPostquirurgicoController.getEstadoPostquirurgicoByCirugia);

module.exports = router;
