const express = require('express');
const router = express.Router();
const MapeoController = require('../controllers/mapeo.controller');

// GET all Mapeos
router.get('/', MapeoController.getAllMapeos);

// GET Mapeo by id
router.get('/:id', MapeoController.getMapeoById);

// POST a new Mapeo
router.post('/create', MapeoController.createMapeo);

// PUT update an existing Mapeo
router.put('/update/:id', MapeoController.updateMapeo);

// DELETE an existing Mapeo
// muy probable no considerar esta opción
// router.delete('/:id', MapeoController.deleteMapeo);

// para los filtros de Mapeo
// que historias creo el estudiante
router.get('/odontograma/:codigo', MapeoController.getMapeoByOdontograma);

module.exports = router;
