const express = require('express');
const router = express.Router();
const PlanTratamientoController = require('../controllers/plantratamiento.controller');

// GET all PlanTratamientos
router.get('/', PlanTratamientoController.getAllPlanTratamientos);

// GET PlanTratamiento by id
router.get('/:id', PlanTratamientoController.getPlanTratamientoById);

// POST a new PlanTratamiento
router.post('/create', PlanTratamientoController.createPlanTratamiento);

// PUT update an existing PlanTratamiento
router.put('/update/:id', PlanTratamientoController.updatePlanTratamiento);

// DELETE an existing PlanTratamiento
// muy probable no considerar esta opción
// router.delete('/:id', PlanTratamientoController.deletePlanTratamiento);

// para los filtros de PlanTratamiento
router.get('/search/cirugia/:codigo', PlanTratamientoController.getPlanTratamientoByCirugia);

module.exports = router;
