const express = require('express');
const router = express.Router();
const TecnicaRadiograficaController = require('../controllers/tecnicaradiografica.controller');

// GET all TecnicaRadiograficas
router.get('/', TecnicaRadiograficaController.getAllTecnicaRadiograficas);

// GET TecnicaRadiografica by id
router.get('/:id', TecnicaRadiograficaController.getTecnicaRadiograficaById);

// POST a new TecnicaRadiografica
router.post('/create', TecnicaRadiograficaController.createTecnicaRadiografica);

// PUT update an existing TecnicaRadiografica
router.put('/update/:id', TecnicaRadiograficaController.updateTecnicaRadiografica);

// DELETE an existing TecnicaRadiografica
// muy probable no considerar esta opción
// router.delete('/:id', TecnicaRadiograficaController.deleteTecnicaRadiografica);

// para los filtros de TecnicaRadiografica
router.get('/search/operatorio/:codigo', TecnicaRadiograficaController.getTecnicaRadiograficaByOperatoria);

module.exports = router;
